/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import schemacrawler.schemacrawler.Identifiers;

public class IdentifiersTest {
    private final Identifiers identifiers = Identifiers.identifiers().build();

    @Test
    public void blank() {
        String[] words;
        for (String word : words = new String[]{"  ", "\t"}) {
            MatcherAssert.assertThat((String)word, (Object)this.identifiers.isReservedWord(word), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((String)word, (Object)this.identifiers.isToBeQuoted(word), (Matcher)Matchers.is((Object)true));
        }
    }

    @Test
    public void empty() {
        String[] words;
        for (String word : words = new String[]{"", null}) {
            MatcherAssert.assertThat((String)word, (Object)this.identifiers.isReservedWord(word), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((String)word, (Object)this.identifiers.isToBeQuoted(word), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void quotedIdentifiers() {
        String[] words;
        for (String word : words = new String[]{"1234", "w@w", "e.e", "\u0967\u0968\u0969\u096a\u096b\u096c\u096d\u096e\u096f\u0966", "Global Counts", "Trail ", " leaD"}) {
            MatcherAssert.assertThat((String)word, (Object)this.identifiers.isReservedWord(word), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((String)word, (Object)this.identifiers.isToBeQuoted(word), (Matcher)Matchers.is((Object)true));
        }
    }

    @Test
    public void quotedNames() {
        String[] names = new String[]{"one name", "\"UPDATE\"", "1234", "goodname", "\"goodname\""};
        String[] quotedNames = new String[]{"\"one name\"", "\"UPDATE\"", "\"1234\"", "goodname", "\"goodname\""};
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String quotedName = quotedNames[i];
            MatcherAssert.assertThat((Object)quotedName, (Matcher)Matchers.equalTo((Object)this.identifiers.quoteName(name)));
        }
    }

    @Test
    public void sqlReservedWords() {
        String[] words;
        for (String word : words = new String[]{"update", "UPDATE"}) {
            MatcherAssert.assertThat((String)word, (Object)this.identifiers.isReservedWord(word), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((String)word, (Object)this.identifiers.isToBeQuoted(word), (Matcher)Matchers.is((Object)true));
        }
    }

    @Test
    public void unquotedIdentifiers() {
        String[] words;
        for (String word : words = new String[]{"qwer", "Qwer", "qweR", "qwEr", "QWER", "Q2w", "q2W", "q2w", "w_w", "W_W", "_W", "W_", "\u0939\u092e", "\u0939\u096d\u092e", "\u096d\u092e", "\u0939\u096d", "\u0939\u093f\u0902\u0926\u0940", "\u0926\u0940\u096e\u0926\u0940"}) {
            MatcherAssert.assertThat((String)word, (Object)this.identifiers.isReservedWord(word), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((String)word, (Object)this.identifiers.isToBeQuoted(word), (Matcher)Matchers.is((Object)false));
        }
    }
}

