/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.sql.JDBCType;
import java.sql.SQLType;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import schemacrawler.schema.JavaSqlType;
import schemacrawler.schema.JavaSqlTypeGroup;

public class JavaSqlTypeTest {
    @Test
    public void bad() {
        JavaSqlType javaSqlType = new JavaSqlType(new SQLType(){

            @Override
            public String getName() {
                return null;
            }

            @Override
            public String getVendor() {
                return null;
            }

            @Override
            public Integer getVendorTypeNumber() {
                return null;
            }
        }, Object.class, JavaSqlTypeGroup.unknown);
        MatcherAssert.assertThat((Object)javaSqlType.getName(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)javaSqlType.getVendor(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)javaSqlType.getVendorTypeNumber(), (Matcher)CoreMatchers.is((Object)Integer.MIN_VALUE));
        MatcherAssert.assertThat((Object)javaSqlType.getDefaultMappedClass(), (Matcher)CoreMatchers.is(Object.class));
        MatcherAssert.assertThat((Object)javaSqlType.getJavaSqlTypeGroup(), (Matcher)CoreMatchers.is((Object)JavaSqlTypeGroup.unknown));
        MatcherAssert.assertThat((Object)javaSqlType.toString(), (Matcher)CoreMatchers.is((Object)"null\tnull\tunknown"));
    }

    @Test
    public void javaSqlType_compareTo() {
        JavaSqlType javaSqlType = new JavaSqlType((SQLType)JDBCType.INTEGER, Integer.class, JavaSqlTypeGroup.integer);
        MatcherAssert.assertThat((Object)javaSqlType.compareTo(null), (Matcher)CoreMatchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((Object)JavaSqlType.UNKNOWN.compareTo(null), (Matcher)CoreMatchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((Object)javaSqlType.compareTo(javaSqlType), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)JavaSqlType.UNKNOWN.compareTo(JavaSqlType.UNKNOWN), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)javaSqlType.compareTo(JavaSqlType.UNKNOWN), (Matcher)CoreMatchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0))));
        MatcherAssert.assertThat((Object)JavaSqlType.UNKNOWN.compareTo(javaSqlType), (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void javaSqlType_equals() {
        EqualsVerifier.forClass(JavaSqlType.class).withIgnoredFields(new String[]{"javaSqlTypeGroup", "defaultMappedClass"}).withNonnullFields(new String[]{"sqlType"}).withPrefabValues(SQLType.class, (Object)JDBCType.INTEGER, (Object)JDBCType.VARCHAR).verify();
    }

    @Test
    public void known() {
        JavaSqlType javaSqlType = new JavaSqlType((SQLType)JDBCType.INTEGER, Integer.class, JavaSqlTypeGroup.integer);
        MatcherAssert.assertThat((Object)javaSqlType.getName(), (Matcher)CoreMatchers.is((Object)"INTEGER"));
        MatcherAssert.assertThat((Object)javaSqlType.getVendor(), (Matcher)CoreMatchers.is((Object)"java.sql"));
        MatcherAssert.assertThat((Object)javaSqlType.getVendorTypeNumber(), (Matcher)CoreMatchers.is((Object)JDBCType.INTEGER.getVendorTypeNumber()));
        MatcherAssert.assertThat((Object)javaSqlType.getDefaultMappedClass(), (Matcher)CoreMatchers.is(Integer.class));
        MatcherAssert.assertThat((Object)javaSqlType.getJavaSqlTypeGroup(), (Matcher)CoreMatchers.is((Object)JavaSqlTypeGroup.integer));
        MatcherAssert.assertThat((Object)javaSqlType.toString(), (Matcher)CoreMatchers.is((Object)"INTEGER\t4\tinteger"));
    }

    @Test
    public void unknown() {
        JavaSqlType javaSqlType = JavaSqlType.UNKNOWN;
        MatcherAssert.assertThat((Object)javaSqlType.getName(), (Matcher)CoreMatchers.is((Object)"UNKNOWN"));
        MatcherAssert.assertThat((Object)javaSqlType.getVendor(), (Matcher)CoreMatchers.is((Object)"us.fatehi.schemacrawler"));
        MatcherAssert.assertThat((Object)javaSqlType.getVendorTypeNumber(), (Matcher)CoreMatchers.is((Object)Integer.MIN_VALUE));
        MatcherAssert.assertThat((Object)javaSqlType.getDefaultMappedClass(), (Matcher)CoreMatchers.is(Object.class));
        MatcherAssert.assertThat((Object)javaSqlType.getJavaSqlTypeGroup(), (Matcher)CoreMatchers.is((Object)JavaSqlTypeGroup.unknown));
        MatcherAssert.assertThat((Object)javaSqlType.toString(), (Matcher)CoreMatchers.is((Object)"UNKNOWN\t-2147483648\tunknown"));
    }
}

