/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.jupiter.api.Test;
import schemacrawler.inclusionrule.ExcludeAll;
import schemacrawler.inclusionrule.IncludeAll;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionRule;
import schemacrawler.schema.RoutineType;
import schemacrawler.schemacrawler.DatabaseObjectRuleForInclusion;
import schemacrawler.schemacrawler.LimitOptions;
import schemacrawler.schemacrawler.LimitOptionsBuilder;

public class LimitOptionsBuilderTest {
    @Test
    public void inclusionRules() {
        IncludeAll includeAll = new IncludeAll();
        ExcludeAll excludeAll = new ExcludeAll();
        RegularExpressionRule inclusionRule = new RegularExpressionRule(".*PUBLIC.*", "");
        Pattern pattern = Pattern.compile(".*PUBLIC.*");
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder();
        LimitOptions limitOptions = limitOptionsBuilder.toOptions();
        for (DatabaseObjectRuleForInclusion databaseObjectRuleForInclusion : DatabaseObjectRuleForInclusion.values()) {
            if (databaseObjectRuleForInclusion.isExcludeByDefault()) {
                MatcherAssert.assertThat((Object)limitOptions.get(databaseObjectRuleForInclusion), (Matcher)Matchers.is((Object)excludeAll));
                continue;
            }
            MatcherAssert.assertThat((Object)limitOptions.get(databaseObjectRuleForInclusion), (Matcher)Matchers.is((Object)includeAll));
        }
        for (DatabaseObjectRuleForInclusion databaseObjectRuleForInclusion : DatabaseObjectRuleForInclusion.values()) {
            limitOptionsBuilder.include(databaseObjectRuleForInclusion, (InclusionRule)inclusionRule);
        }
        limitOptions = limitOptionsBuilder.toOptions();
        for (DatabaseObjectRuleForInclusion databaseObjectRuleForInclusion : DatabaseObjectRuleForInclusion.values()) {
            MatcherAssert.assertThat((Object)limitOptions.get(databaseObjectRuleForInclusion), (Matcher)Matchers.is((Object)inclusionRule));
        }
        for (DatabaseObjectRuleForInclusion databaseObjectRuleForInclusion : DatabaseObjectRuleForInclusion.values()) {
            limitOptionsBuilder.include(databaseObjectRuleForInclusion, null);
        }
        limitOptions = limitOptionsBuilder.toOptions();
        for (DatabaseObjectRuleForInclusion databaseObjectRuleForInclusion : DatabaseObjectRuleForInclusion.values()) {
            if (databaseObjectRuleForInclusion.isExcludeByDefault()) {
                MatcherAssert.assertThat((Object)limitOptions.get(databaseObjectRuleForInclusion), (Matcher)Matchers.is((Object)excludeAll));
                continue;
            }
            MatcherAssert.assertThat((Object)limitOptions.get(databaseObjectRuleForInclusion), (Matcher)Matchers.is((Object)includeAll));
        }
        limitOptions = limitOptionsBuilder.includeSchemas((InclusionRule)inclusionRule).toOptions();
        MatcherAssert.assertThat((Object)limitOptions.get(DatabaseObjectRuleForInclusion.ruleForSchemaInclusion), (Matcher)Matchers.is((Object)inclusionRule));
        limitOptions = limitOptionsBuilder.includeTables((InclusionRule)inclusionRule).toOptions();
        MatcherAssert.assertThat((Object)limitOptions.get(DatabaseObjectRuleForInclusion.ruleForTableInclusion), (Matcher)Matchers.is((Object)inclusionRule));
        limitOptions = limitOptionsBuilder.includeRoutines((InclusionRule)inclusionRule).toOptions();
        MatcherAssert.assertThat((Object)limitOptions.get(DatabaseObjectRuleForInclusion.ruleForRoutineInclusion), (Matcher)Matchers.is((Object)inclusionRule));
        limitOptions = limitOptionsBuilder.includeSequences((InclusionRule)inclusionRule).toOptions();
        MatcherAssert.assertThat((Object)limitOptions.get(DatabaseObjectRuleForInclusion.ruleForSequenceInclusion), (Matcher)Matchers.is((Object)inclusionRule));
        limitOptions = limitOptionsBuilder.includeSynonyms((InclusionRule)inclusionRule).toOptions();
        MatcherAssert.assertThat((Object)limitOptions.get(DatabaseObjectRuleForInclusion.ruleForSynonymInclusion), (Matcher)Matchers.is((Object)inclusionRule));
        limitOptions = limitOptionsBuilder.includeColumns((InclusionRule)inclusionRule).toOptions();
        MatcherAssert.assertThat((Object)limitOptions.get(DatabaseObjectRuleForInclusion.ruleForColumnInclusion), (Matcher)Matchers.is((Object)inclusionRule));
        limitOptions = limitOptionsBuilder.includeRoutineParameters((InclusionRule)inclusionRule).toOptions();
        MatcherAssert.assertThat((Object)limitOptions.get(DatabaseObjectRuleForInclusion.ruleForRoutineParameterInclusion), (Matcher)Matchers.is((Object)inclusionRule));
        limitOptions = limitOptionsBuilder.includeSchemas(pattern).toOptions();
        MatcherAssert.assertThat((Object)limitOptions.get(DatabaseObjectRuleForInclusion.ruleForSchemaInclusion), (Matcher)Matchers.is((Object)inclusionRule));
        limitOptions = limitOptionsBuilder.includeTables(pattern).toOptions();
        MatcherAssert.assertThat((Object)limitOptions.get(DatabaseObjectRuleForInclusion.ruleForTableInclusion), (Matcher)Matchers.is((Object)inclusionRule));
        limitOptions = limitOptionsBuilder.includeRoutines(pattern).toOptions();
        MatcherAssert.assertThat((Object)limitOptions.get(DatabaseObjectRuleForInclusion.ruleForRoutineInclusion), (Matcher)Matchers.is((Object)inclusionRule));
        limitOptions = limitOptionsBuilder.includeSequences(pattern).toOptions();
        MatcherAssert.assertThat((Object)limitOptions.get(DatabaseObjectRuleForInclusion.ruleForSequenceInclusion), (Matcher)Matchers.is((Object)inclusionRule));
        limitOptions = limitOptionsBuilder.includeSynonyms(pattern).toOptions();
        MatcherAssert.assertThat((Object)limitOptions.get(DatabaseObjectRuleForInclusion.ruleForSynonymInclusion), (Matcher)Matchers.is((Object)inclusionRule));
        limitOptions = limitOptionsBuilder.includeColumns(pattern).toOptions();
        MatcherAssert.assertThat((Object)limitOptions.get(DatabaseObjectRuleForInclusion.ruleForColumnInclusion), (Matcher)Matchers.is((Object)inclusionRule));
        limitOptions = limitOptionsBuilder.includeRoutineParameters(pattern).toOptions();
        MatcherAssert.assertThat((Object)limitOptions.get(DatabaseObjectRuleForInclusion.ruleForRoutineParameterInclusion), (Matcher)Matchers.is((Object)inclusionRule));
        limitOptions = limitOptionsBuilder.includeAllRoutines().toOptions();
        MatcherAssert.assertThat((Object)limitOptions.get(DatabaseObjectRuleForInclusion.ruleForRoutineInclusion), (Matcher)Matchers.is((Object)includeAll));
        limitOptions = limitOptionsBuilder.includeAllSequences().toOptions();
        MatcherAssert.assertThat((Object)limitOptions.get(DatabaseObjectRuleForInclusion.ruleForSequenceInclusion), (Matcher)Matchers.is((Object)includeAll));
        limitOptions = limitOptionsBuilder.includeAllSynonyms().toOptions();
        MatcherAssert.assertThat((Object)limitOptions.get(DatabaseObjectRuleForInclusion.ruleForSynonymInclusion), (Matcher)Matchers.is((Object)includeAll));
    }

    @Test
    public void newOptions() {
        this.assertDefaultLimitOptions(LimitOptionsBuilder.newLimitOptions());
        this.assertDefaultLimitOptions(LimitOptionsBuilder.builder().fromOptions(null).toOptions());
    }

    @Test
    public void routineTypes() {
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder();
        LimitOptions limitOptions = limitOptionsBuilder.toOptions();
        MatcherAssert.assertThat((Object)limitOptions.getRoutineTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new RoutineType[]{RoutineType.function, RoutineType.procedure}));
        LimitOptions limitOptionsPlayback = LimitOptionsBuilder.builder().fromOptions(limitOptions).toOptions();
        MatcherAssert.assertThat((Object)limitOptionsPlayback.getRoutineTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new RoutineType[]{RoutineType.function, RoutineType.procedure}));
        limitOptionsBuilder.routineTypes(new ArrayList());
        limitOptions = limitOptionsBuilder.toOptions();
        MatcherAssert.assertThat((Object)limitOptions.getRoutineTypes(), (Matcher)Matchers.is((Matcher)IsEmptyCollection.empty()));
        limitOptionsPlayback = LimitOptionsBuilder.builder().fromOptions(limitOptions).toOptions();
        MatcherAssert.assertThat((Object)limitOptionsPlayback.getRoutineTypes(), (Matcher)Matchers.is((Matcher)IsEmptyCollection.empty()));
        limitOptionsBuilder.routineTypes(Arrays.asList(RoutineType.function));
        limitOptions = limitOptionsBuilder.toOptions();
        MatcherAssert.assertThat((Object)limitOptions.getRoutineTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new RoutineType[]{RoutineType.function}));
        limitOptionsPlayback = LimitOptionsBuilder.builder().fromOptions(limitOptions).toOptions();
        MatcherAssert.assertThat((Object)limitOptionsPlayback.getRoutineTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new RoutineType[]{RoutineType.function}));
        limitOptionsBuilder.routineTypes((Collection)null);
        limitOptions = limitOptionsBuilder.toOptions();
        MatcherAssert.assertThat((Object)limitOptions.getRoutineTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new RoutineType[]{RoutineType.function, RoutineType.procedure}));
        limitOptionsPlayback = LimitOptionsBuilder.builder().fromOptions(limitOptions).toOptions();
        MatcherAssert.assertThat((Object)limitOptionsPlayback.getRoutineTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new RoutineType[]{RoutineType.function, RoutineType.procedure}));
    }

    @Test
    public void routineTypesWithString() {
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder();
        LimitOptions limitOptions = limitOptionsBuilder.toOptions();
        MatcherAssert.assertThat((Object)limitOptions.getRoutineTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new RoutineType[]{RoutineType.function, RoutineType.procedure}));
        LimitOptions limitOptionsPlayback = LimitOptionsBuilder.builder().fromOptions(limitOptions).toOptions();
        MatcherAssert.assertThat((Object)limitOptionsPlayback.getRoutineTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new RoutineType[]{RoutineType.function, RoutineType.procedure}));
        limitOptionsBuilder.routineTypes("");
        limitOptions = limitOptionsBuilder.toOptions();
        MatcherAssert.assertThat((Object)limitOptions.getRoutineTypes(), (Matcher)Matchers.is((Matcher)IsEmptyCollection.empty()));
        limitOptionsPlayback = LimitOptionsBuilder.builder().fromOptions(limitOptions).toOptions();
        MatcherAssert.assertThat((Object)limitOptionsPlayback.getRoutineTypes(), (Matcher)Matchers.is((Matcher)IsEmptyCollection.empty()));
        limitOptionsBuilder.routineTypes("function");
        limitOptions = limitOptionsBuilder.toOptions();
        MatcherAssert.assertThat((Object)limitOptions.getRoutineTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new RoutineType[]{RoutineType.function}));
        limitOptionsPlayback = LimitOptionsBuilder.builder().fromOptions(limitOptions).toOptions();
        MatcherAssert.assertThat((Object)limitOptionsPlayback.getRoutineTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new RoutineType[]{RoutineType.function}));
        limitOptionsBuilder.routineTypes("function,PROCEDURE");
        limitOptions = limitOptionsBuilder.toOptions();
        MatcherAssert.assertThat((Object)limitOptions.getRoutineTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new RoutineType[]{RoutineType.function, RoutineType.procedure}));
        limitOptionsPlayback = LimitOptionsBuilder.builder().fromOptions(limitOptions).toOptions();
        MatcherAssert.assertThat((Object)limitOptionsPlayback.getRoutineTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new RoutineType[]{RoutineType.function, RoutineType.procedure}));
        limitOptionsBuilder.routineTypes("function,bad_value");
        limitOptions = limitOptionsBuilder.toOptions();
        MatcherAssert.assertThat((Object)limitOptions.getRoutineTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new RoutineType[]{RoutineType.function}));
        limitOptionsPlayback = LimitOptionsBuilder.builder().fromOptions(limitOptions).toOptions();
        MatcherAssert.assertThat((Object)limitOptionsPlayback.getRoutineTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new RoutineType[]{RoutineType.function}));
        limitOptionsBuilder.routineTypes((String)null);
        limitOptions = limitOptionsBuilder.toOptions();
        MatcherAssert.assertThat((Object)limitOptions.getRoutineTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new RoutineType[]{RoutineType.function, RoutineType.procedure}));
        limitOptionsPlayback = LimitOptionsBuilder.builder().fromOptions(limitOptions).toOptions();
        MatcherAssert.assertThat((Object)limitOptionsPlayback.getRoutineTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new RoutineType[]{RoutineType.function, RoutineType.procedure}));
    }

    @Test
    public void tableNamePattern() {
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder();
        LimitOptions limitOptions = limitOptionsBuilder.toOptions();
        MatcherAssert.assertThat((Object)limitOptions.getTableNamePattern(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        limitOptionsBuilder.tableNamePattern("");
        limitOptions = limitOptionsBuilder.toOptions();
        MatcherAssert.assertThat((Object)limitOptions.getTableNamePattern(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        limitOptionsBuilder.tableNamePattern("\t\t");
        limitOptions = limitOptionsBuilder.toOptions();
        MatcherAssert.assertThat((Object)limitOptions.getTableNamePattern(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        limitOptionsBuilder.tableNamePattern("pattern");
        limitOptions = limitOptionsBuilder.toOptions();
        MatcherAssert.assertThat((Object)limitOptions.getTableNamePattern(), (Matcher)Matchers.is((Object)"pattern"));
        limitOptionsBuilder.tableNamePattern(null);
        limitOptions = limitOptionsBuilder.toOptions();
        MatcherAssert.assertThat((Object)limitOptions.getTableNamePattern(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void tableTypes() {
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder();
        LimitOptions limitOptions = limitOptionsBuilder.toOptions();
        MatcherAssert.assertThat((Object)limitOptions.getTableTypes().toArray(), (Matcher)Matchers.is((Object)new String[]{"TABLE", "VIEW", "BASE TABLE"}));
        LimitOptions limitOptionsPlayback = LimitOptionsBuilder.builder().fromOptions(limitOptions).toOptions();
        MatcherAssert.assertThat((Object)limitOptionsPlayback.getTableTypes().toArray(), (Matcher)Matchers.is((Object)new String[]{"TABLE", "VIEW", "BASE TABLE"}));
        limitOptionsBuilder.tableTypes(new ArrayList());
        limitOptions = limitOptionsBuilder.toOptions();
        MatcherAssert.assertThat((Object)limitOptions.getTableTypes().toArray(), (Matcher)Matchers.is((Object)new String[0]));
        limitOptionsPlayback = LimitOptionsBuilder.builder().fromOptions(limitOptions).toOptions();
        MatcherAssert.assertThat((Object)limitOptionsPlayback.getTableTypes().toArray(), (Matcher)Matchers.is((Object)new String[0]));
        limitOptionsBuilder.tableTypes("TABLE");
        limitOptions = limitOptionsBuilder.toOptions();
        MatcherAssert.assertThat((Object)limitOptions.getTableTypes().toArray(), (Matcher)Matchers.is((Object)new String[]{"TABLE"}));
        limitOptionsPlayback = LimitOptionsBuilder.builder().fromOptions(limitOptions).toOptions();
        MatcherAssert.assertThat((Object)limitOptionsPlayback.getTableTypes().toArray(), (Matcher)Matchers.is((Object)new String[]{"TABLE"}));
        limitOptionsBuilder.tableTypes((Collection)null);
        limitOptions = limitOptionsBuilder.toOptions();
        MatcherAssert.assertThat((Object)limitOptions.getTableTypes().toArray(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        limitOptionsPlayback = LimitOptionsBuilder.builder().fromOptions(limitOptions).toOptions();
        MatcherAssert.assertThat((Object)limitOptionsPlayback.getTableTypes().toArray(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        limitOptionsBuilder.tableTypes((String[])null);
        limitOptions = limitOptionsBuilder.toOptions();
        MatcherAssert.assertThat((Object)limitOptions.getTableTypes().toArray(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        limitOptionsPlayback = LimitOptionsBuilder.builder().fromOptions(limitOptions).toOptions();
        MatcherAssert.assertThat((Object)limitOptionsPlayback.getTableTypes().toArray(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    private void assertDefaultLimitOptions(LimitOptions limitOptions) {
        MatcherAssert.assertThat((Object)limitOptions.getRoutineTypes(), (Matcher)Matchers.is(EnumSet.of(RoutineType.function, RoutineType.procedure)));
        MatcherAssert.assertThat(Arrays.asList(limitOptions.getTableTypes().toArray()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"TABLE", "VIEW", "BASE TABLE"}));
        IncludeAll includeAll = new IncludeAll();
        ExcludeAll excludeAll = new ExcludeAll();
        for (DatabaseObjectRuleForInclusion databaseObjectRuleForInclusion : DatabaseObjectRuleForInclusion.values()) {
            if (databaseObjectRuleForInclusion.isExcludeByDefault()) {
                MatcherAssert.assertThat((Object)limitOptions.get(databaseObjectRuleForInclusion), (Matcher)Matchers.is((Object)excludeAll));
                continue;
            }
            MatcherAssert.assertThat((Object)limitOptions.get(databaseObjectRuleForInclusion), (Matcher)Matchers.is((Object)includeAll));
        }
    }
}

