/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.ListExclusionRule;

public class ListExclusionRuleTest {
    final InclusionRule exclusionRule = new ListExclusionRule(Arrays.asList("ORDDATA", "\"SYSTEM\"", "APEX_123456", "FLOWS_12345"));

    @Test
    public void closeEnoughs() {
        String[] closeEnoughs;
        for (String closeEnough : closeEnoughs = new String[]{"ORDDAT", "SYSTEM", "APEX_12345", "FLOWS_1234567"}) {
            MatcherAssert.assertThat((String)String.format("<%s> - exclude close enough strings - inclusion rule should evaluate to true", closeEnough), (Object)this.exclusionRule.test((Object)closeEnough), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void empties() {
        String[] empties;
        for (String empty : empties = new String[]{null, "", "\t", "  "}) {
            MatcherAssert.assertThat((String)String.format("<%s> - exclude empties - inclusion rule should evaluate to false", empty), (Object)this.exclusionRule.test((Object)empty), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void valid() {
        String[] valids;
        for (String valid : valids = new String[]{"ORDDATA", "\"SYSTEM\"", "APEX_123456", "FLOWS_12345"}) {
            MatcherAssert.assertThat((String)String.format("<%s> - include valid schemas - inclusion rule should evaluate to false", valid), (Object)this.exclusionRule.test((Object)valid), (Matcher)CoreMatchers.is((Object)false));
        }
    }
}

