/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.sql.Connection;
import java.util.Collection;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Index;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableReference;
import schemacrawler.schema.TableRelationshipType;
import schemacrawler.schemacrawler.IdentifierQuotingStrategy;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.WithTestDatabase;
import schemacrawler.utility.MetaDataUtility;

@WithTestDatabase
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class MetadataUtilityTest {
    private Catalog catalog;

    @Test
    public void columnsListAsStringConstraint() throws Exception {
        Schema schema = (Schema)this.catalog.lookupSchema("PUBLIC.BOOKS").get();
        MatcherAssert.assertThat((String)"BOOKS Schema not found", (Object)schema, (Matcher)Matchers.notNullValue());
        Table table = (Table)this.catalog.lookupTable(schema, "BOOKS").get();
        MatcherAssert.assertThat((String)"BOOKS Table not found", (Object)table, (Matcher)Matchers.notNullValue());
        PrimaryKey pk = table.getPrimaryKey();
        MatcherAssert.assertThat((String)"Index not found", (Object)pk, (Matcher)Matchers.notNullValue());
        String columnsListAsStringChild = MetaDataUtility.getColumnsListAsString((TableConstraint)pk, (IdentifierQuotingStrategy)IdentifierQuotingStrategy.quote_all, (String)"'");
        MatcherAssert.assertThat((Object)columnsListAsStringChild, (Matcher)Matchers.is((Object)"'ID'"));
    }

    @Test
    public void columnsListAsStringFk() throws Exception {
        Schema schema = (Schema)this.catalog.lookupSchema("PUBLIC.BOOKS").get();
        MatcherAssert.assertThat((String)"BOOKS Schema not found", (Object)schema, (Matcher)Matchers.notNullValue());
        Table table = (Table)this.catalog.lookupTable(schema, "BOOKS").get();
        MatcherAssert.assertThat((String)"BOOKS Table not found", (Object)table, (Matcher)Matchers.notNullValue());
        ForeignKey fk = table.getForeignKeys().toArray(new ForeignKey[0])[0];
        MatcherAssert.assertThat((String)"Foreign key not found", (Object)fk, (Matcher)Matchers.notNullValue());
        String columnsListAsStringChild = MetaDataUtility.getColumnsListAsString((TableReference)fk, (TableRelationshipType)TableRelationshipType.child, (IdentifierQuotingStrategy)IdentifierQuotingStrategy.quote_all, (String)"'");
        MatcherAssert.assertThat((Object)columnsListAsStringChild, (Matcher)Matchers.is((Object)"'PREVIOUSEDITIONID'"));
        String columnsListAsStringParent = MetaDataUtility.getColumnsListAsString((TableReference)fk, (TableRelationshipType)TableRelationshipType.parent, (IdentifierQuotingStrategy)IdentifierQuotingStrategy.quote_all, (String)"'");
        MatcherAssert.assertThat((Object)columnsListAsStringParent, (Matcher)Matchers.is((Object)"'ID'"));
        String columnsListAsStringNone = MetaDataUtility.getColumnsListAsString((TableReference)fk, (TableRelationshipType)TableRelationshipType.none, (IdentifierQuotingStrategy)IdentifierQuotingStrategy.quote_all, (String)"'");
        MatcherAssert.assertThat((Object)columnsListAsStringNone, (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void columnsListAsStringIndex() throws Exception {
        Schema schema = (Schema)this.catalog.lookupSchema("PUBLIC.BOOKS").get();
        MatcherAssert.assertThat((String)"BOOKS Schema not found", (Object)schema, (Matcher)Matchers.notNullValue());
        Table table = (Table)this.catalog.lookupTable(schema, "BOOKS").get();
        MatcherAssert.assertThat((String)"BOOKS Table not found", (Object)table, (Matcher)Matchers.notNullValue());
        Index index = table.getIndexes().toArray(new Index[0])[0];
        MatcherAssert.assertThat((String)"Index not found", (Object)index, (Matcher)Matchers.notNullValue());
        String columnsListAsStringChild = MetaDataUtility.getColumnsListAsString((Index)index, (IdentifierQuotingStrategy)IdentifierQuotingStrategy.quote_all, (String)"'");
        MatcherAssert.assertThat((Object)columnsListAsStringChild, (Matcher)Matchers.is((Object)"'ID'"));
    }

    @Test
    public void columnsListAsStringTable() throws Exception {
        Schema schema = (Schema)this.catalog.lookupSchema("PUBLIC.BOOKS").get();
        MatcherAssert.assertThat((String)"BOOKS Schema not found", (Object)schema, (Matcher)Matchers.notNullValue());
        Table table = (Table)this.catalog.lookupTable(schema, "BOOKS").get();
        MatcherAssert.assertThat((String)"BOOKS Table not found", (Object)table, (Matcher)Matchers.notNullValue());
        String columnsListAsStringChild = MetaDataUtility.getColumnsListAsString((Table)table, (IdentifierQuotingStrategy)IdentifierQuotingStrategy.quote_all, (String)"'");
        MatcherAssert.assertThat((Object)columnsListAsStringChild, (Matcher)Matchers.is((Object)"'ID', 'TITLE', 'DESCRIPTION', 'PUBLISHERID', 'PUBLICATIONDATE', 'PRICE', 'PREVIOUSEDITIONID'"));
    }

    @Test
    public void fkUtilities() throws Exception {
        Schema schema = (Schema)this.catalog.lookupSchema("PUBLIC.BOOKS").get();
        MatcherAssert.assertThat((String)"BOOKS Schema not found", (Object)schema, (Matcher)Matchers.notNullValue());
        Table table = (Table)this.catalog.lookupTable(schema, "BOOKS").get();
        MatcherAssert.assertThat((String)"BOOKS Table not found", (Object)table, (Matcher)Matchers.notNullValue());
        ForeignKey fk = table.getForeignKeys().toArray(new ForeignKey[0])[0];
        MatcherAssert.assertThat((String)"Foreign key not found", (Object)fk, (Matcher)Matchers.notNullValue());
        ColumnReference columnReference = fk.getColumnReferences().toArray(new ColumnReference[0])[0];
        MatcherAssert.assertThat((String)"Column reference not found", (Object)columnReference, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)MetaDataUtility.findForeignKeyCardinality((TableReference)fk), (Matcher)Matchers.is((Object)MetaDataUtility.ForeignKeyCardinality.zero_one));
        MatcherAssert.assertThat((Object)MetaDataUtility.foreignKeyColumnNames((TableReference)fk), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"PUBLIC.BOOKS.BOOKS.PREVIOUSEDITIONID"}));
    }

    @BeforeAll
    public void loadCatalog(Connection connection) {
        SchemaCrawlerOptions schemaCrawlerOptions = DatabaseTestUtility.schemaCrawlerOptionsWithMaximumSchemaInfoLevel;
        try {
            this.catalog = DatabaseTestUtility.getCatalog(connection, schemaCrawlerOptions);
        }
        catch (Exception e) {
            Assertions.fail((String)"Catalog not loaded", (Throwable)e);
        }
    }

    @Test
    public void tableUtilities() throws Exception {
        Schema schema = (Schema)this.catalog.lookupSchema("PUBLIC.BOOKS").get();
        MatcherAssert.assertThat((String)"BOOKS Schema not found", (Object)schema, (Matcher)Matchers.notNullValue());
        Table table = (Table)this.catalog.lookupTable(schema, "BOOKS").get();
        MatcherAssert.assertThat((String)"BOOKS Table not found", (Object)table, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat(MetaDataUtility.allIndexCoumnNames((Table)table).stream().flatMap(Collection::stream).collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"PUBLIC.BOOKS.BOOKS.ID", "PUBLIC.BOOKS.BOOKS.PREVIOUSEDITIONID"}));
        MatcherAssert.assertThat(MetaDataUtility.uniqueIndexCoumnNames((Table)table).stream().flatMap(Collection::stream).collect(Collectors.toSet()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"PUBLIC.BOOKS.BOOKS.ID", "PUBLIC.BOOKS.BOOKS.PREVIOUSEDITIONID"}));
        Index index = table.getIndexes().toArray(new Index[0])[0];
        MatcherAssert.assertThat((String)"Index not found", (Object)index, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)MetaDataUtility.columnNames((Index)index), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"PUBLIC.BOOKS.BOOKS.ID"}));
    }
}

