/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.utility.NamedObjectSort;

public class NamedObjectSortTest {
    @ParameterizedTest
    @ValueSource(booleans={true, false, true, false, false, true})
    public void namedObjectSort(boolean sortAlphabetically) throws Exception {
        List<NamedObject> expected = this.createExpectedList(sortAlphabetically);
        ArrayList<NamedObject> objects = new ArrayList<NamedObject>(expected);
        Collections.shuffle(objects);
        MatcherAssert.assertThat((String)"Test named object list is not shuffled", objects, (Matcher)CoreMatchers.is((Matcher)Matchers.not(expected)));
        Collections.sort(objects, NamedObjectSort.getNamedObjectSort((boolean)sortAlphabetically));
        MatcherAssert.assertThat((String)"Test named object list is not sorted", objects, (Matcher)CoreMatchers.is(expected));
    }

    private List<NamedObject> createExpectedList(boolean sortAlphabetically) {
        Object[] names = new String[]{"ID", "FIRSTNAME", "LASTNAME", "ADDRESS1", "ADDRESS2", "CITY", "STATE", "POSTALCODE", "COUNTRY"};
        if (sortAlphabetically) {
            Arrays.sort(names);
        }
        int length = names.length;
        NullNamedObject nullNamedObject = new NullNamedObject();
        ArrayList<NamedObject> expected = new ArrayList<NamedObject>();
        for (int i = 0; i < length; ++i) {
            expected.add(new NewNamedObject((String)names[i], i));
        }
        expected.add(nullNamedObject);
        expected.add(null);
        if (sortAlphabetically) {
            expected.remove(nullNamedObject);
            expected.add(0, nullNamedObject);
        }
        return expected;
    }

    private class NullNamedObject
    implements NamedObject {
        private static final long serialVersionUID = -5606558254139597791L;

        private NullNamedObject() {
        }

        public int compareTo(NamedObject o) {
            return 1;
        }

        public String getFullName() {
            return null;
        }

        public String getName() {
            return null;
        }

        public NamedObjectKey key() {
            return null;
        }
    }

    private class NewNamedObject
    implements NamedObject {
        private static final long serialVersionUID = 6242517200200079638L;
        private final int value;
        private final String name;

        public NewNamedObject(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public int compareTo(NamedObject o) {
            if (o == null) {
                return -1;
            }
            if (o instanceof NewNamedObject) {
                return Integer.compare(this.value, ((NewNamedObject)o).value);
            }
            return -1;
        }

        public String getFullName() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public NamedObjectKey key() {
            return null;
        }
    }
}

