/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionInclusionRule;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.QueryUtility;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.TestContext;
import schemacrawler.test.utility.TestWriter;
import schemacrawler.test.utility.WithTestDatabase;

@WithTestDatabase
@ResolveTestContext
public class QueryUtilityTest {
    @Test
    public void executeAgainstSchema(TestContext testContext, Connection cxn) throws Exception {
        Query query = new Query("Tables for schema", "SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE REGEXP_MATCHES(TABLE_SCHEMA, '${schemas}') ORDER BY TABLE_NAME");
        RegularExpressionInclusionRule schemaInclusionRule = new RegularExpressionInclusionRule("BOOKS");
        this.executeAgainstSchemaTest(testContext, cxn, query, (InclusionRule)schemaInclusionRule);
    }

    @Test
    public void executeAgainstSchemaNoMatch(TestContext testContext, Connection cxn) throws Exception {
        Query query = new Query("Tables for schema", "SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE REGEXP_MATCHES(TABLE_SCHEMA, '${schemas}') ORDER BY TABLE_NAME");
        RegularExpressionInclusionRule schemaInclusionRule = new RegularExpressionInclusionRule("NONE");
        int rows = 0;
        try (Connection connection = cxn;
             Statement statement = connection.createStatement();
             ResultSet resultSet = QueryUtility.executeAgainstSchema((Query)query, (Statement)statement, (InclusionRule)schemaInclusionRule);){
            while (resultSet.next()) {
                ++rows;
            }
        }
        MatcherAssert.assertThat((Object)rows, (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void executeAgainstSchemaNoTemplate(TestContext testContext, Connection cxn) throws Exception {
        Query query = new Query("Tables for schema", "SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA= 'BOOKS' ORDER BY TABLE_NAME");
        RegularExpressionInclusionRule schemaInclusionRule = new RegularExpressionInclusionRule("NONE");
        this.executeAgainstSchemaTest(testContext, cxn, query, (InclusionRule)schemaInclusionRule);
    }

    @Test
    public void executeForScalar(TestContext testContext, Connection cxn) throws Exception {
        Query query = new Query("Select scalar", "SELECT POSTALCODE FROM PUBLIC.BOOKS.AUTHORS WHERE LASTNAME = 'Shaffer'");
        Object scalar = QueryUtility.executeForScalar((Query)query, (Connection)cxn);
        MatcherAssert.assertThat((Object)scalar, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)scalar, (Matcher)Matchers.is((Object)"37032"));
    }

    @Test
    public void executeForScalarNotPresent(TestContext testContext, Connection cxn) throws Exception {
        Query query = new Query("Select scalar", "SELECT POSTALCODE FROM PUBLIC.BOOKS.AUTHORS WHERE LASTNAME = 'Fatehi'");
        Object scalar = QueryUtility.executeForScalar((Query)query, (Connection)cxn);
        MatcherAssert.assertThat((Object)scalar, (Matcher)Matchers.nullValue());
    }

    private void executeAgainstSchemaTest(TestContext testContext, Connection cxn, Query query, InclusionRule schemaInclusionRule) throws IOException, SQLException {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();
             Connection connection = cxn;
             Statement statement = connection.createStatement();
             ResultSet resultSet = QueryUtility.executeAgainstSchema((Query)query, (Statement)statement, (InclusionRule)schemaInclusionRule);){
            while (resultSet.next()) {
                out.println(resultSet.getString("TABLE_NAME"));
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }
}

