/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.PropertyUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import schemacrawler.crawl.ResultsCrawler;
import schemacrawler.schema.ResultsColumn;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.TestContext;
import schemacrawler.test.utility.TestWriter;
import schemacrawler.test.utility.WithTestDatabase;

@WithTestDatabase
@ResolveTestContext
public class ResultColumnsTest {
    private static final Logger LOGGER = Logger.getLogger(ResultColumnsTest.class.getName());

    @Test
    public void columns(TestContext testContext, Connection cxn) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            String sql = "SELECT                                                                     PUBLIC.BOOKS.BOOKS.TITLE AS BOOK,                                         PUBLIC.BOOKS.AUTHORS.FIRSTNAME + ' ' + PUBLIC.BOOKS.AUTHORS.LASTNAME,     PUBLIC.BOOKS.BOOKS.PRICE                                                 FROM                                                                       PUBLIC.BOOKS.BOOKS                                                        INNER JOIN PUBLIC.BOOKS.BOOKAUTHORS                                         ON PUBLIC.BOOKS.BOOKS.ID = PUBLIC.BOOKS.BOOKAUTHORS.BOOKID              INNER JOIN PUBLIC.BOOKS.AUTHORS                                             ON PUBLIC.BOOKS.AUTHORS.ID = PUBLIC.BOOKS.BOOKAUTHORS.AUTHORID         ";
            try (Connection connection = cxn;
                 Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT                                                                     PUBLIC.BOOKS.BOOKS.TITLE AS BOOK,                                         PUBLIC.BOOKS.AUTHORS.FIRSTNAME + ' ' + PUBLIC.BOOKS.AUTHORS.LASTNAME,     PUBLIC.BOOKS.BOOKS.PRICE                                                 FROM                                                                       PUBLIC.BOOKS.BOOKS                                                        INNER JOIN PUBLIC.BOOKS.BOOKAUTHORS                                         ON PUBLIC.BOOKS.BOOKS.ID = PUBLIC.BOOKS.BOOKAUTHORS.BOOKID              INNER JOIN PUBLIC.BOOKS.AUTHORS                                             ON PUBLIC.BOOKS.AUTHORS.ID = PUBLIC.BOOKS.BOOKAUTHORS.AUTHORID         ");){
                ResultsColumn[] columns;
                ResultsColumns resultColumns = new ResultsCrawler(resultSet).crawl();
                MatcherAssert.assertThat((String)"Could not obtain result columns", (Object)resultColumns, (Matcher)Matchers.notNullValue());
                out.println("full-name: " + resultColumns.getFullName());
                out.println("columns: " + resultColumns.getColumnsListAsString());
                out.println();
                for (ResultsColumn column : columns = resultColumns.getColumns().toArray(new ResultsColumn[0])) {
                    LOGGER.log(Level.FINE, column.toString());
                    out.println("column: " + column.getFullName());
                    TreeMap properties = new TreeMap(PropertyUtils.describe((Object)column));
                    for (Map.Entry property : properties.entrySet()) {
                        out.println(String.format("  %s: %s", property.getKey(), property.getValue()));
                    }
                    out.println("  database type: " + column.getColumnDataType().getDatabaseSpecificTypeName());
                    out.println("  type: " + column.getColumnDataType().getJavaSqlType().getName());
                }
                out.println();
                out.println("# Additional Tests");
                out.println("lookup C2: " + resultColumns.lookupColumn("C2").orElse(null));
                out.println("lookup PRICE: " + resultColumns.lookupColumn("PRICE").orElse(null));
                out.println("lookup NOT_A_COLUMN: " + resultColumns.lookupColumn("NOT_A_COLUMN").orElse(null));
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }
}

