/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.sql.Connection;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionInclusionRule;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineParameter;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.FilterOptionsBuilder;
import schemacrawler.schemacrawler.GrepOptionsBuilder;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.TestContext;
import schemacrawler.test.utility.TestWriter;
import schemacrawler.test.utility.WithTestDatabase;

@WithTestDatabase
@ResolveTestContext
public class SchemaCrawlerGrepTest {
    @Test
    public void grepColumns(TestContext testContext, Connection connection) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            GrepOptionsBuilder grepOptionsBuilder = GrepOptionsBuilder.builder().includeGreppedColumns((InclusionRule)new RegularExpressionInclusionRule(".*\\..*\\.BOOKID"));
            SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withGrepOptions(grepOptionsBuilder.toOptions());
            Catalog catalog = DatabaseTestUtility.getCatalog(connection, schemaCrawlerOptions);
            Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
            MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)6));
            for (Schema schema : schemas) {
                Table[] tables;
                out.println("schema: " + schema.getFullName());
                for (Table table : tables = catalog.getTables(schema).toArray(new Table[0])) {
                    out.println("  table: " + table.getFullName());
                    Object[] columns = table.getColumns().toArray(new Column[0]);
                    Arrays.sort(columns);
                    for (Object column : columns) {
                        out.println("    column: " + column.getFullName());
                    }
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }

    @Test
    public void grepColumnsAndIncludeParentTables(Connection connection) throws Exception {
        GrepOptionsBuilder grepOptionsBuilder = GrepOptionsBuilder.builder().includeGreppedColumns((InclusionRule)new RegularExpressionInclusionRule(".*\\.BOOKAUTHORS\\..*"));
        FilterOptionsBuilder filterOptionsBuilder = FilterOptionsBuilder.builder().parentTableFilterDepth(1);
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withGrepOptions(grepOptionsBuilder.toOptions());
        Catalog catalog = DatabaseTestUtility.getCatalog(connection, schemaCrawlerOptions);
        Schema schema = (Schema)catalog.lookupSchema("PUBLIC.BOOKS").get();
        MatcherAssert.assertThat((String)"Schema PUBLIC.BOOKS not found", (Object)schema, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)catalog.getTables(schema), (Matcher)Matchers.hasSize((int)1));
        Table table = (Table)catalog.lookupTable(schema, "BOOKAUTHORS").get();
        MatcherAssert.assertThat((String)"Table BOOKAUTHORS not found", (Object)table, (Matcher)Matchers.notNullValue());
        schemaCrawlerOptions = schemaCrawlerOptions.withFilterOptions(filterOptionsBuilder.toOptions());
        catalog = DatabaseTestUtility.getCatalog(connection, schemaCrawlerOptions);
        schema = (Schema)catalog.lookupSchema("PUBLIC.BOOKS").get();
        MatcherAssert.assertThat((String)"Schema PUBLIC.BOOKS not found", (Object)schema, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)catalog.getTables(schema).size(), (Matcher)Matchers.is((Object)3));
        table = (Table)catalog.lookupTable(schema, "BOOKAUTHORS").get();
        MatcherAssert.assertThat((String)"Table BOOKAUTHORS not found", (Object)table, (Matcher)Matchers.notNullValue());
        table = (Table)catalog.lookupTable(schema, "BOOKS").get();
        MatcherAssert.assertThat((String)"Table BOOKS not found", (Object)table, (Matcher)Matchers.notNullValue());
        table = (Table)catalog.lookupTable(schema, "AUTHORS").get();
        MatcherAssert.assertThat((String)"Table AUTHORS not found", (Object)table, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void grepCombined(TestContext testContext, Connection connection) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            GrepOptionsBuilder grepOptionsBuilder = GrepOptionsBuilder.builder().includeGreppedColumns((InclusionRule)new RegularExpressionInclusionRule(".*\\..*\\.BOOKID")).includeGreppedDefinitions((InclusionRule)new RegularExpressionInclusionRule(".*book author.*"));
            SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withGrepOptions(grepOptionsBuilder.toOptions());
            Catalog catalog = DatabaseTestUtility.getCatalog(connection, schemaCrawlerOptions);
            Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
            MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)6));
            for (Schema schema : schemas) {
                Table[] tables;
                out.println("schema: " + schema.getFullName());
                for (Table table : tables = catalog.getTables(schema).toArray(new Table[0])) {
                    out.println("  table: " + table.getFullName());
                    Object[] columns = table.getColumns().toArray(new Column[0]);
                    Arrays.sort(columns);
                    for (Object column : columns) {
                        out.println("    column: " + column.getFullName());
                    }
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }

    @Test
    public void grepDefinitions(TestContext testContext, Connection connection) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            GrepOptionsBuilder grepOptionsBuilder = GrepOptionsBuilder.builder().includeGreppedDefinitions((InclusionRule)new RegularExpressionInclusionRule(".*book author.*"));
            SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withGrepOptions(grepOptionsBuilder.toOptions());
            Catalog catalog = DatabaseTestUtility.getCatalog(connection, schemaCrawlerOptions);
            Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
            MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)6));
            for (Schema schema : schemas) {
                Table[] tables;
                out.println("schema: " + schema.getFullName());
                for (Table table : tables = catalog.getTables(schema).toArray(new Table[0])) {
                    out.println("  table: " + table.getFullName());
                    Object[] columns = table.getColumns().toArray(new Column[0]);
                    Arrays.sort(columns);
                    for (Object column : columns) {
                        out.println("    column: " + column.getFullName());
                    }
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }

    @Test
    public void grepProcedures(TestContext testContext, Connection connection) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().includeAllRoutines();
            GrepOptionsBuilder grepOptionsBuilder = GrepOptionsBuilder.builder().includeGreppedRoutineParameters((InclusionRule)new RegularExpressionInclusionRule(".*\\.B_COUNT"));
            SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptionsBuilder.toOptions()).withGrepOptions(grepOptionsBuilder.toOptions());
            Catalog catalog = DatabaseTestUtility.getCatalog(connection, schemaCrawlerOptions);
            Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
            MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)6));
            for (Schema schema : schemas) {
                Routine[] routines;
                out.println("schema: " + schema.getFullName());
                for (Routine routine : routines = catalog.getRoutines(schema).toArray(new Routine[0])) {
                    RoutineParameter[] parameters;
                    out.println("  routine: " + routine.getFullName());
                    for (RoutineParameter column : parameters = routine.getParameters().toArray(new RoutineParameter[0])) {
                        out.println("    parameter: " + column.getFullName());
                    }
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }
}

