/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import com.github.npathai.hamcrestopt.OptionalMatchers;
import java.sql.Connection;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import schemacrawler.crawl.NotLoadedException;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionInclusionRule;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.GrepOptionsBuilder;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.WithTestDatabase;

@WithTestDatabase
public class SchemaCrawlerReferenceTest {
    @Test
    public void fkReferences(Connection connection) throws Exception {
        SchemaCrawlerOptions schemaCrawlerOptions = DatabaseTestUtility.schemaCrawlerOptionsWithMaximumSchemaInfoLevel;
        int fkReferenceCount = 0;
        Catalog catalog = DatabaseTestUtility.getCatalog(connection, schemaCrawlerOptions);
        Collection tables = catalog.getTables();
        for (Table table : tables) {
            Collection foreignKeys = table.getForeignKeys();
            for (ForeignKey foreignKey : foreignKeys) {
                for (ColumnReference fkColumnRef : foreignKey) {
                    this.assertReferencedColumnExists(catalog, fkColumnRef.getPrimaryKeyColumn());
                    this.assertReferencedColumnExists(catalog, fkColumnRef.getForeignKeyColumn());
                    ++fkReferenceCount;
                }
            }
        }
        MatcherAssert.assertThat((Object)fkReferenceCount, (Matcher)Matchers.is((Object)28));
    }

    @Test
    public void fkReferencesForGreppedAndFilteredTables1(Connection connection) throws Exception {
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().includeTables((InclusionRule)new RegularExpressionInclusionRule(".*\\.BOOKAUTHORS"));
        GrepOptionsBuilder grepOptionsBuilder = GrepOptionsBuilder.builder().includeGreppedColumns((InclusionRule)new RegularExpressionInclusionRule(".*\\.BOOKAUTHORS\\..*"));
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptionsBuilder.toOptions()).withGrepOptions(grepOptionsBuilder.toOptions());
        int fkReferenceCount = 0;
        Catalog catalog = DatabaseTestUtility.getCatalog(connection, schemaCrawlerOptions);
        Collection tables = catalog.getTables();
        for (Table table : tables) {
            Collection foreignKeys = table.getForeignKeys();
            for (ForeignKey foreignKey : foreignKeys) {
                for (ColumnReference fkColumnRef : foreignKey) {
                    this.assertReferencedColumnDoesNotExist(catalog, fkColumnRef.getPrimaryKeyColumn(), true);
                    this.assertReferencedColumnExists(catalog, fkColumnRef.getForeignKeyColumn());
                    ++fkReferenceCount;
                }
            }
        }
        MatcherAssert.assertThat((Object)fkReferenceCount, (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void fkReferencesForGreppedAndFilteredTables2(Connection connection) throws Exception {
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().includeTables((InclusionRule)new RegularExpressionInclusionRule(".*\\.AUTHORS"));
        GrepOptionsBuilder grepOptionsBuilder = GrepOptionsBuilder.builder().includeGreppedColumns((InclusionRule)new RegularExpressionInclusionRule(".*\\.AUTHORS\\..*"));
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptionsBuilder.toOptions()).withGrepOptions(grepOptionsBuilder.toOptions());
        int fkReferenceCount = 0;
        Catalog catalog = DatabaseTestUtility.getCatalog(connection, schemaCrawlerOptions);
        Collection tables = catalog.getTables();
        for (Table table : tables) {
            Collection foreignKeys = table.getForeignKeys();
            for (ForeignKey foreignKey : foreignKeys) {
                for (ColumnReference fkColumnRef : foreignKey) {
                    this.assertReferencedColumnExists(catalog, fkColumnRef.getPrimaryKeyColumn());
                    this.assertReferencedColumnDoesNotExist(catalog, fkColumnRef.getForeignKeyColumn(), true);
                    ++fkReferenceCount;
                }
            }
        }
        MatcherAssert.assertThat((Object)fkReferenceCount, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void fkReferencesForGreppedTables1(Connection connection) throws Exception {
        GrepOptionsBuilder grepOptionsBuilder = GrepOptionsBuilder.builder().includeGreppedColumns((InclusionRule)new RegularExpressionInclusionRule(".*\\.BOOKAUTHORS\\..*"));
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withGrepOptions(grepOptionsBuilder.toOptions());
        int fkReferenceCount = 0;
        Catalog catalog = DatabaseTestUtility.getCatalog(connection, schemaCrawlerOptions);
        Collection tables = catalog.getTables();
        for (Table table : tables) {
            Collection foreignKeys = table.getForeignKeys();
            for (ForeignKey foreignKey : foreignKeys) {
                for (ColumnReference fkColumnRef : foreignKey) {
                    this.assertReferencedColumnDoesNotExist(catalog, fkColumnRef.getPrimaryKeyColumn(), false);
                    this.assertReferencedColumnExists(catalog, fkColumnRef.getForeignKeyColumn());
                    ++fkReferenceCount;
                }
            }
        }
        MatcherAssert.assertThat((Object)fkReferenceCount, (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void fkReferencesForGreppedTables2(Connection connection) throws Exception {
        GrepOptionsBuilder grepOptionsBuilder = GrepOptionsBuilder.builder().includeGreppedColumns((InclusionRule)new RegularExpressionInclusionRule(".*\\.AUTHORS\\..*"));
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withGrepOptions(grepOptionsBuilder.toOptions());
        int fkReferenceCount = 0;
        Catalog catalog = DatabaseTestUtility.getCatalog(connection, schemaCrawlerOptions);
        Collection tables = catalog.getTables();
        for (Table table : tables) {
            Collection foreignKeys = table.getForeignKeys();
            for (ForeignKey foreignKey : foreignKeys) {
                for (ColumnReference fkColumnRef : foreignKey) {
                    this.assertReferencedColumnExists(catalog, fkColumnRef.getPrimaryKeyColumn());
                    this.assertReferencedColumnDoesNotExist(catalog, fkColumnRef.getForeignKeyColumn(), false);
                    ++fkReferenceCount;
                }
            }
        }
        MatcherAssert.assertThat((Object)fkReferenceCount, (Matcher)Matchers.is((Object)1));
    }

    private void assertReferencedColumnDoesNotExist(Catalog catalog, Column column, boolean assertDataNotLoaded) {
        Table table = (Table)column.getParent();
        MatcherAssert.assertThat((String)("Primary key table table should not be in the database - " + table.getName()), (Object)catalog.lookupTable(table.getSchema(), table.getName()), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((String)"Column references do not match", (Object)(column == table.lookupColumn(column.getName()).get() ? 1 : 0), (Matcher)Matchers.is((Object)true));
        if (assertDataNotLoaded) {
            try {
                table.getTableType();
                Assertions.fail((String)"An exception should be thrown indicating that this table was not loaded from the database");
            }
            catch (NotLoadedException notLoadedException) {
                // empty catch block
            }
            try {
                column.getColumnDataType();
                Assertions.fail((String)"An exception should be thrown indicating that this table was not loaded from the database");
            }
            catch (NotLoadedException notLoadedException) {
                // empty catch block
            }
        }
    }

    private void assertReferencedColumnExists(Catalog catalog, Column column) {
        MatcherAssert.assertThat((Object)column, (Matcher)Matchers.notNullValue());
        Table table = (Table)column.getParent();
        MatcherAssert.assertThat((String)("Table references do not match - " + table.getName()), (table == catalog.lookupTable(table.getSchema(), table.getName()).get() ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"Column references do not match", (column == table.lookupColumn(column.getName()).get() ? 1 : 0) != 0);
    }
}

