/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import com.github.npathai.hamcrestopt.OptionalMatchers;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.TreeMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import schemacrawler.crawl.AlternateKeyBuilder;
import schemacrawler.crawl.ForeignKeyRetrieverTest;
import schemacrawler.crawl.IndexRetrieverTest;
import schemacrawler.crawl.PrimaryKeyRetrieverTest;
import schemacrawler.crawl.TableColumnRetrieverTest;
import schemacrawler.crawl.WeakAssociationBuilder;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionExclusionRule;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.DataTypeType;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.DatabaseProperty;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Grant;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.JdbcDriverProperty;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Property;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineParameter;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.schema.TableReference;
import schemacrawler.schema.TableRelationshipType;
import schemacrawler.schema.Trigger;
import schemacrawler.schema.View;
import schemacrawler.schema.WeakAssociation;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.LoadOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.ResolveTestContext;
import schemacrawler.test.utility.TestContext;
import schemacrawler.test.utility.TestUtility;
import schemacrawler.test.utility.TestWriter;
import schemacrawler.test.utility.WithTestDatabase;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.Utility;

@WithTestDatabase
@ResolveTestContext
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class SchemaCrawlerTest {
    private Catalog catalog;

    private static String printColumnDataType(ColumnDataType columnDataType) {
        StringBuilder buffer = new StringBuilder();
        boolean isUserDefined = columnDataType.getType() == DataTypeType.user_defined;
        String typeName = columnDataType.getFullName();
        String dataType = (isUserDefined ? "user defined " : "") + "column data-type";
        String nullable = (columnDataType.isNullable() ? "" : "not ") + "nullable";
        String autoIncrementable = (columnDataType.isAutoIncrementable() ? "" : "not ") + "auto-incrementable";
        String createParameters = columnDataType.getCreateParameters();
        String definedWith = "defined with " + (Utility.isBlank((CharSequence)createParameters) ? "no parameters" : createParameters);
        String literalPrefix = columnDataType.getLiteralPrefix();
        String literalPrefixText = Utility.isBlank((CharSequence)literalPrefix) ? "no literal prefix" : "literal prefix " + literalPrefix;
        String literalSuffix = columnDataType.getLiteralSuffix();
        String literalSuffixText = Utility.isBlank((CharSequence)literalSuffix) ? "no literal suffix" : "literal suffix " + literalSuffix;
        String javaSqlType = "java.sql.Types: " + columnDataType.getJavaSqlType().getName();
        String precision = "precision " + columnDataType.getPrecision();
        String minimumScale = "minimum scale " + columnDataType.getMinimumScale();
        String maximumScale = "maximum scale " + columnDataType.getMaximumScale();
        buffer.append(typeName).append("\n").append("  ").append(dataType).append("\n").append("  ").append(definedWith).append("\n").append("  ").append(nullable).append("\n").append("  ").append(autoIncrementable).append("\n").append("  ").append(literalPrefixText).append("\n").append("  ").append(literalSuffixText).append("\n").append("  ").append(columnDataType.getSearchable().toString()).append("\n").append("  ").append(precision).append("\n").append("  ").append(minimumScale).append("\n").append("  ").append(maximumScale).append("\n").append("  ").append(javaSqlType);
        if (isUserDefined) {
            ColumnDataType baseColumnDataType = columnDataType.getBaseType();
            String baseTypeName = baseColumnDataType == null ? "" : baseColumnDataType.getFullName();
            buffer.append("\n").append("  ").append("based on ").append(baseTypeName);
        }
        return buffer.toString();
    }

    @Test
    public void alternateKeys(TestContext testContext) throws Exception {
        TestWriter testout;
        SchemaReference alternateKeySchema = new SchemaReference("PUBLIC", "BOOKS");
        AlternateKeyBuilder builder = AlternateKeyBuilder.builder((Catalog)this.catalog);
        builder.addAlternateKey(new AlternateKeyBuilder.AlternateKeyDefinition((Schema)alternateKeySchema, "AUTHORS", "1_alternate_key", Arrays.asList("ID")));
        builder.addAlternateKey(new AlternateKeyBuilder.AlternateKeyDefinition((Schema)alternateKeySchema, "OTHERTABLE", "2_alternate_key", Arrays.asList("ID")));
        builder.addAlternateKey(new AlternateKeyBuilder.AlternateKeyDefinition((Schema)alternateKeySchema, "AUTHORS", "3_alternate_key", Arrays.asList("OTHERCOLUMN")));
        try (TestWriter out = testout = new TestWriter();){
            Schema[] schemas = this.catalog.getSchemas().toArray(new Schema[0]);
            MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)5));
            for (Schema schema : schemas) {
                Table[] tables;
                out.println("schema: " + schema.getFullName());
                for (Table table : tables = this.catalog.getTables(schema).toArray(new Table[0])) {
                    out.println("  table: " + table.getFullName());
                    Collection alternateKeys = table.getAlternateKeys();
                    for (PrimaryKey alternateKey : alternateKeys) {
                        out.println("    altermate key: " + alternateKey.getName());
                        out.println("      columns: ");
                        List constrainedColumns = alternateKey.getConstrainedColumns();
                        for (TableConstraintColumn tableConstraintColumn : constrainedColumns) {
                            out.println("        ordinal: " + tableConstraintColumn.getOrdinalPosition());
                            out.println("          " + tableConstraintColumn);
                        }
                    }
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }

    @Test
    public void columnDataTypes(TestContext testContext) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Collection columnDataTypes = this.catalog.getColumnDataTypes();
            MatcherAssert.assertThat((String)"ColumnDataType count does not match", (Object)columnDataTypes, (Matcher)Matchers.hasSize((int)30));
            for (ColumnDataType columnDataType : columnDataTypes) {
                MatcherAssert.assertThat((Object)columnDataType, (Matcher)Matchers.notNullValue());
                out.println(SchemaCrawlerTest.printColumnDataType(columnDataType));
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }

    @Test
    public void columnLookup() {
        Schema schema = (Schema)this.catalog.lookupSchema("PUBLIC.BOOKS").get();
        MatcherAssert.assertThat((Object)schema, (Matcher)Matchers.notNullValue());
        Table table = (Table)this.catalog.lookupTable(schema, "AUTHORS").get();
        MatcherAssert.assertThat((Object)table, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)table.lookupColumn(null), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)table.lookupColumn(""), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)table.lookupColumn("NO_COLUMN"), (Matcher)OptionalMatchers.isEmpty());
        MatcherAssert.assertThat((Object)table.lookupColumn("ID"), (Matcher)Matchers.not((Matcher)OptionalMatchers.isEmpty()));
    }

    @Test
    public void columnPrivileges(TestContext testContext) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Schema[] schemas = this.catalog.getSchemas().toArray(new Schema[0]);
            MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)5));
            Table table = (Table)this.catalog.lookupTable(schemas[0], "AUTHORS").get();
            out.println(table.getFullName());
            for (Column column : table.getColumns()) {
                out.println("  " + column.getName());
                Collection privileges = column.getPrivileges();
                for (Privilege privilege : privileges) {
                    out.println(String.format("    privilege: %s", privilege.getName()));
                    Collection grants = privilege.getGrants();
                    for (Grant grant : grants) {
                        out.println("      " + grant);
                    }
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }

    @Test
    public void counts(TestContext testContext) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Schema[] schemas = this.catalog.getSchemas().toArray(new Schema[0]);
            MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)5));
            for (Schema schema : schemas) {
                out.println("schema: " + schema.getFullName());
                Table[] tables = this.catalog.getTables(schema).toArray(new Table[0]);
                Arrays.sort(tables, NamedObjectSort.alphabetical);
                for (Table table : tables) {
                    out.println("  table: " + table.getFullName());
                    out.println("    # columns: " + table.getColumns().size());
                    out.println("    # constraints: " + table.getTableConstraints().size());
                    out.println("    # indexes: " + table.getIndexes().size());
                    out.println("    # foreign keys: " + table.getForeignKeys().size());
                    out.println("    # imported foreign keys: " + table.getExportedForeignKeys().size());
                    out.println("    # exported: " + table.getImportedForeignKeys().size());
                    out.println("    # privileges: " + table.getPrivileges().size());
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }

    @Test
    public void databaseInfo(TestContext testContext) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            DatabaseInfo databaseInfo = this.catalog.getDatabaseInfo();
            Collection dbProperties = databaseInfo.getProperties();
            Collection serverInfo = databaseInfo.getServerInfo();
            MatcherAssert.assertThat((String)"Server info property count does not match", (Object)serverInfo, (Matcher)Matchers.is((Matcher)Matchers.empty()));
            out.println(String.format("username=%s", databaseInfo.getUserName()));
            out.println(String.format("product name=%s", databaseInfo.getProductName()));
            out.println(String.format("product version=%s", databaseInfo.getProductVersion()));
            out.println(String.format("catalog=%s", this.catalog.getName()));
            for (Property serverInfoProperty : serverInfo) {
                MatcherAssert.assertThat((Object)serverInfoProperty, (Matcher)Matchers.notNullValue());
                out.println(serverInfoProperty);
            }
            for (DatabaseProperty dbProperty : dbProperties) {
                MatcherAssert.assertThat((Object)dbProperty, (Matcher)Matchers.notNullValue());
                out.println(dbProperty);
            }
            JdbcDriverInfo jdbcDriverInfo = this.catalog.getJdbcDriverInfo();
            out.println(String.format("connection url=%s", jdbcDriverInfo.getConnectionUrl()));
            out.println(String.format("driver class=%s", jdbcDriverInfo.getDriverClassName()));
            Collection driverProperties = jdbcDriverInfo.getDriverProperties();
            for (JdbcDriverProperty driverProperty : driverProperties) {
                MatcherAssert.assertThat((Object)driverProperty, (Matcher)Matchers.notNullValue());
                out.println(driverProperty);
            }
        }
        String expectedResultsResource = String.format("%s.%s", testContext.testMethodFullName(), TestUtility.javaVersion());
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(expectedResultsResource)));
    }

    @Test
    public void foreignKeys(TestContext testContext) throws Exception {
        ForeignKeyRetrieverTest.verifyRetrieveForeignKeys(this.catalog);
    }

    @Test
    public void indexes(TestContext testContext) throws Exception {
        IndexRetrieverTest.verifyRetrieveIndexes(this.catalog);
    }

    @BeforeAll
    public void loadCatalog(Connection connection) throws Exception {
        SchemaRetrievalOptions schemaRetrievalOptions = TestUtility.newSchemaRetrievalOptions();
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().includeSchemas((InclusionRule)new RegularExpressionExclusionRule(".*\\.FOR_LINT")).includeAllSynonyms().includeAllSequences().includeAllRoutines();
        LoadOptionsBuilder loadOptionsBuilder = LoadOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.maximum());
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptionsBuilder.toOptions()).withLoadOptions(loadOptionsBuilder.toOptions());
        this.catalog = DatabaseTestUtility.getCatalog(connection, schemaRetrievalOptions, schemaCrawlerOptions);
    }

    @Test
    public void primaryKeys(TestContext testContext) throws Exception {
        PrimaryKeyRetrieverTest.verifyRetrievePrimaryKeys(this.catalog);
    }

    @Test
    public void relatedTables(TestContext testContext) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Table[] tables = this.catalog.getTables().toArray(new Table[0]);
            MatcherAssert.assertThat((String)"Table count does not match", (Object)tables, (Matcher)Matchers.arrayWithSize((int)13));
            Arrays.sort(tables, NamedObjectSort.alphabetical);
            for (Table table : tables) {
                out.println("  table: " + table.getFullName());
                out.println("    # columns: " + table.getColumns().size());
                out.println("    # child tables: " + table.getRelatedTables(TableRelationshipType.child));
                out.println("    # parent tables: " + table.getRelatedTables(TableRelationshipType.parent));
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }

    @Test
    public void routineParameters(TestContext testContext) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
            Routine[] routines = this.catalog.getRoutines((Schema)schema).toArray(new Routine[0]);
            MatcherAssert.assertThat((String)"Routine count does not match", (Object)routines, (Matcher)Matchers.arrayWithSize((int)4));
            for (Routine routine : routines) {
                MatcherAssert.assertThat((Object)routine, (Matcher)Matchers.notNullValue());
                out.println("routine: " + routine.getName());
                List parameters = routine.getParameters();
                for (RoutineParameter parameter : parameters) {
                    out.println("  parameter: " + parameter.getName());
                    out.println(String.format("  - %s=%s", "data-type", parameter.getColumnDataType()));
                    out.println(String.format("  - %s=%s", "size", parameter.getSize()));
                    out.println(String.format("  - %s=%s", "decimal digits", parameter.getDecimalDigits()));
                    out.println(String.format("  - %s=%s", "width", parameter.getWidth()));
                    out.println(String.format("  - %s=%s", "nullable", parameter.isNullable()));
                    out.println(String.format("  - %s=%s", "ordinal position", parameter.getOrdinalPosition()));
                    out.println(String.format("  - %s=%s", "remarks", parameter.getRemarks()));
                    out.println(String.format("  - %s=%s", "attibutes", ""));
                }
            }
            out.println();
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }

    @Test
    public void routines(TestContext testContext) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
            Routine[] routines = this.catalog.getRoutines((Schema)schema).toArray(new Routine[0]);
            MatcherAssert.assertThat((String)"Routine count does not match", (Object)routines, (Matcher)Matchers.arrayWithSize((int)4));
            for (Routine routine : routines) {
                MatcherAssert.assertThat((Object)routine, (Matcher)Matchers.notNullValue());
                out.println("routine: " + routine.getName());
                out.println("  specific name: " + routine.getSpecificName());
                out.println("  return type: " + routine.getReturnType());
                out.println("  body type: " + routine.getRoutineBodyType());
                out.println("  definition:\n" + routine.getDefinition());
                out.println();
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }

    @Test
    public void schemaEquals() {
        SchemaReference schema1 = new SchemaReference("PUBLIC", "BOOKS");
        MatcherAssert.assertThat((String)"Could not find any tables", (Object)this.catalog.getTables((Schema)schema1), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((String)"Wrong number of routines", (Object)this.catalog.getRoutines((Schema)schema1), (Matcher)Matchers.hasSize((int)4));
        SchemaReference schema2 = new SchemaReference("PUBLIC", "BOOKS");
        MatcherAssert.assertThat((String)"Schema not not match", (Object)schema1, (Matcher)Matchers.equalTo((Object)schema2));
        MatcherAssert.assertThat((String)"Tables do not match", (Object)this.catalog.getTables((Schema)schema1), (Matcher)Matchers.equalTo((Object)this.catalog.getTables((Schema)schema2)));
        MatcherAssert.assertThat((String)"Routines do not match", (Object)this.catalog.getRoutines((Schema)schema1), (Matcher)Matchers.equalTo((Object)this.catalog.getRoutines((Schema)schema2)));
        Table table1 = this.catalog.getTables((Schema)schema1).toArray(new Table[0])[0];
        Table table2 = this.catalog.getTables((Schema)schema1).toArray(new Table[0])[1];
        MatcherAssert.assertThat((String)"Tables should not be equal", (Object)table1, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)table2)));
    }

    @Test
    public void sequences(TestContext testContext) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Schema schema = (Schema)this.catalog.lookupSchema("PUBLIC.BOOKS").get();
            MatcherAssert.assertThat((String)"BOOKS Schema not found", (Object)schema, (Matcher)Matchers.notNullValue());
            Sequence[] sequences = this.catalog.getSequences(schema).toArray(new Sequence[0]);
            MatcherAssert.assertThat((String)"Sequence count does not match", (Object)sequences, (Matcher)Matchers.arrayWithSize((int)1));
            for (Sequence sequence : sequences) {
                MatcherAssert.assertThat((Object)sequence, (Matcher)Matchers.notNullValue());
                out.println("sequence: " + sequence.getName());
                out.println("  increment: " + sequence.getIncrement());
                out.println("  start value: " + sequence.getStartValue());
                out.println("  minimum value: " + sequence.getMinimumValue());
                out.println("  maximum value: " + sequence.getMaximumValue());
                out.println("  cycle?: " + sequence.isCycle());
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }

    @Test
    public void synonyms(TestContext testContext) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Schema schema = (Schema)this.catalog.lookupSchema("PUBLIC.BOOKS").get();
            MatcherAssert.assertThat((String)"BOOKS Schema not found", (Object)schema, (Matcher)Matchers.notNullValue());
            Synonym[] synonyms = this.catalog.getSynonyms(schema).toArray(new Synonym[0]);
            MatcherAssert.assertThat((String)"Synonym count does not match", (Object)synonyms, (Matcher)Matchers.arrayWithSize((int)1));
            for (Synonym synonym : synonyms) {
                MatcherAssert.assertThat((Object)synonym, (Matcher)Matchers.notNullValue());
                out.println("synonym: " + synonym.getName());
                out.println("  class: " + synonym.getReferencedObject().getClass().getSimpleName());
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }

    @Test
    public void tableColumns(TestContext testContext) throws Exception {
        TableColumnRetrieverTest.verifyRetrieveTableColumns(this.catalog);
    }

    @Test
    public void tableConstraints(TestContext testContext) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Schema[] schemas = this.catalog.getSchemas().toArray(new Schema[0]);
            MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)5));
            for (Schema schema : schemas) {
                Table[] tables;
                out.println("schema: " + schema.getFullName());
                for (Table table : tables = this.catalog.getTables(schema).toArray(new Table[0])) {
                    TableConstraint[] tableConstraints;
                    out.println("  table: " + table.getFullName());
                    for (TableConstraint tableConstraint : tableConstraints = table.getTableConstraints().toArray(new TableConstraint[0])) {
                        out.println("    constraint: " + tableConstraint.getName());
                        out.println("      type: " + tableConstraint.getType());
                        if (!(tableConstraint instanceof TableConstraint)) continue;
                        TableConstraint dependentTableConstraint = tableConstraint;
                        List columns = dependentTableConstraint.getConstrainedColumns();
                        for (TableConstraintColumn tableConstraintColumn : columns) {
                            out.println("      on column: " + tableConstraintColumn.getName());
                        }
                    }
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }

    @Test
    public void tablePrivileges(TestContext testContext) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Schema[] schemas = this.catalog.getSchemas().toArray(new Schema[0]);
            MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)5));
            Table table = (Table)this.catalog.lookupTable(schemas[0], "AUTHORS").get();
            out.println(table.getFullName());
            Collection privileges = table.getPrivileges();
            for (Privilege privilege : privileges) {
                out.println(String.format("  privilege: %s", privilege.getName()));
                Collection grants = privilege.getGrants();
                for (Grant grant : grants) {
                    if (!privilege.getName().equals("SELECT")) {
                        MatcherAssert.assertThat((Object)grant.getGrantor(), (Matcher)Matchers.is((Object)"_SYSTEM"));
                        MatcherAssert.assertThat((Object)grant.getGrantee(), (Matcher)Matchers.is((Object)"SA"));
                        MatcherAssert.assertThat((Object)grant.isGrantable(), (Matcher)Matchers.is((Object)true));
                    }
                    out.println("    " + grant);
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }

    @Test
    public void tables(TestContext testContext) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Schema[] schemas = this.catalog.getSchemas().toArray(new Schema[0]);
            MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)5));
            for (Schema schema : schemas) {
                Table[] tables = this.catalog.getTables(schema).toArray(new Table[0]);
                Arrays.sort(tables, NamedObjectSort.alphabetical);
                for (Table table : tables) {
                    out.println(String.format("%s [%s]", table.getFullName(), table.getTableType()));
                    TreeMap tableAttributes = new TreeMap(table.getAttributes());
                    for (Map.Entry tableAttribute : tableAttributes.entrySet()) {
                        out.println(String.format("  ~ %s=%s", tableAttribute.getKey(), tableAttribute.getValue()));
                    }
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }

    @Test
    public void tablesSort() {
        String[] tableNames = new String[]{"AUTHORS", "BOOKS", "COUPONS", "CUSTOMERDATA", "CUSTOMERS", "Global Counts", "PUBLISHERS", "BOOKAUTHORS", "\u0392\u0399\u0392\u039b\u038a\u0391", "AUTHORSLIST"};
        Random rnd = new Random();
        Schema[] schemas = this.catalog.getSchemas().toArray(new Schema[0]);
        MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)5));
        Schema schema = schemas[0];
        Object[] tables = this.catalog.getTables(schema).toArray(new Table[0]);
        for (int i = 0; i < 10; ++i) {
            for (int tableIdx = 0; tableIdx < tables.length; ++tableIdx) {
                Table table = tables[tableIdx];
                MatcherAssert.assertThat((String)("Table name does not match in iteration " + i), (Object)tableNames[tableIdx], (Matcher)Matchers.is((Object)table.getName()));
            }
            for (int k = tables.length; k > 1; --k) {
                int i1 = k - 1;
                int i2 = rnd.nextInt(k);
                Object tmp = tables[i1];
                tables[i1] = tables[i2];
                tables[i2] = tmp;
            }
            Arrays.sort(tables);
        }
    }

    @Test
    public void triggers(TestContext testContext) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Table[] tables;
            SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
            for (Table table : tables = this.catalog.getTables((Schema)schema).toArray(new Table[0])) {
                for (Trigger trigger : table.getTriggers()) {
                    out.println(String.format("  trigger: %s", trigger.getFullName()));
                    out.println(String.format("    action condition: %s", trigger.getActionCondition()));
                    out.println(String.format("    condition timing: %s", trigger.getConditionTiming()));
                    out.println(String.format("    action order: %s", trigger.getActionOrder()));
                    out.println(String.format("    action orientation: %s", trigger.getActionOrientation()));
                    out.println(String.format("    action statement: %s", trigger.getActionStatement()));
                    out.println(String.format("    event manipulation type: %s", trigger.getEventManipulationType()));
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }

    @Test
    public void views(TestContext testContext) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            Schema[] schemas = this.catalog.getSchemas().toArray(new Schema[0]);
            MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)5));
            for (Schema schema : schemas) {
                Table[] tables = this.catalog.getTables(schema).toArray(new Table[0]);
                Arrays.sort(tables, NamedObjectSort.alphabetical);
                for (Table table : tables) {
                    if (!(table instanceof View)) continue;
                    View view = (View)table;
                    out.println(String.format("%s [%s]", view.getFullName(), view.getTableType()));
                    out.println(String.format("  - check option: %s", view.getCheckOption()));
                    out.println(String.format("  - updatable?: %b", view.isUpdatable()));
                    out.println(String.format("  - definition: %s", view.getDefinition()));
                    out.println("  - table usage");
                    for (Table usedTable : view.getTableUsage()) {
                        out.println(String.format("    - table: %s", usedTable));
                    }
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }

    @Test
    public void weakAssociations(TestContext testContext) throws Exception {
        TestWriter testout;
        Column pkColumn = (Column)((Table)this.catalog.lookupTable((Schema)new SchemaReference("PUBLIC", "BOOKS"), "AUTHORS").get()).lookupColumn("ID").get();
        Column fkColumn = (Column)((Table)this.catalog.lookupTable((Schema)new SchemaReference("PUBLIC", "BOOKS"), "BOOKS").get()).lookupColumn("ID").get();
        WeakAssociationBuilder builder = WeakAssociationBuilder.builder((Catalog)this.catalog);
        builder.clear();
        builder.addColumnReference(new WeakAssociationBuilder.WeakAssociationColumn(fkColumn), new WeakAssociationBuilder.WeakAssociationColumn(pkColumn));
        builder.findOrCreate("1_weak");
        builder.clear();
        builder.addColumnReference(new WeakAssociationBuilder.WeakAssociationColumn((Schema)new SchemaReference("PRIVATE", "LIBRARY"), "BOOKAUTHORS", "AUTHORID"), new WeakAssociationBuilder.WeakAssociationColumn(pkColumn));
        builder.findOrCreate("2_weak_partial_fk");
        builder.clear();
        builder.addColumnReference(new WeakAssociationBuilder.WeakAssociationColumn(fkColumn), new WeakAssociationBuilder.WeakAssociationColumn((Schema)new SchemaReference("PRIVATE", "LIBRARY"), "BOOKS", "ID"));
        builder.findOrCreate("3_weak_partial_pk");
        builder.clear();
        builder.addColumnReference(new WeakAssociationBuilder.WeakAssociationColumn((Schema)new SchemaReference("PRIVATE", "LIBRARY"), "BOOKAUTHORS", "AUTHORID"), new WeakAssociationBuilder.WeakAssociationColumn((Schema)new SchemaReference("PRIVATE", "LIBRARY"), "AUTHORS", "ID"));
        builder.findOrCreate("4_weak_partial_both");
        builder.clear();
        builder.findOrCreate("5_weak_no_references");
        builder.clear();
        builder.addColumnReference(new WeakAssociationBuilder.WeakAssociationColumn((Schema)new SchemaReference("PRIVATE", "LIBRARY"), "BOOKAUTHORS", "AUTHORID"), new WeakAssociationBuilder.WeakAssociationColumn(pkColumn));
        builder.addColumnReference(new WeakAssociationBuilder.WeakAssociationColumn(fkColumn), new WeakAssociationBuilder.WeakAssociationColumn((Schema)new SchemaReference("PRIVATE", "LIBRARY"), "AUTHORS", "ID"));
        builder.findOrCreate("6_weak_conflicting");
        builder.clear();
        builder.addColumnReference(new WeakAssociationBuilder.WeakAssociationColumn((Schema)new SchemaReference("PRIVATE", "LIBRARY"), "MAGAZINEARTICLES", "AUTHORID"), new WeakAssociationBuilder.WeakAssociationColumn(pkColumn));
        builder.addColumnReference(new WeakAssociationBuilder.WeakAssociationColumn((Schema)new SchemaReference("PRIVATE", "LIBRARY"), "MAGAZINEARTICLES", "AUTHORID"), new WeakAssociationBuilder.WeakAssociationColumn(pkColumn));
        builder.findOrCreate("7_weak_duplicate");
        builder.clear();
        builder.addColumnReference(new WeakAssociationBuilder.WeakAssociationColumn((Schema)new SchemaReference("PRIVATE", "ALLSALES"), "REGIONS", "POSTALCODE"), new WeakAssociationBuilder.WeakAssociationColumn((Schema)new SchemaReference("PUBLIC", "PUBLISHER SALES"), "SALES", "POSTALCODE"));
        builder.addColumnReference(new WeakAssociationBuilder.WeakAssociationColumn((Schema)new SchemaReference("PRIVATE", "ALLSALES"), "REGIONS", "COUNTRY"), new WeakAssociationBuilder.WeakAssociationColumn((Schema)new SchemaReference("PUBLIC", "PUBLISHER SALES"), "SALES", "COUNTRY"));
        builder.findOrCreate("8_weak_two_references");
        builder.clear();
        builder.addColumnReference(new WeakAssociationBuilder.WeakAssociationColumn((Schema)new SchemaReference("PUBLIC", "BOOKS"), "BOOKS", "OTHEREDITIONID"), new WeakAssociationBuilder.WeakAssociationColumn((Schema)new SchemaReference("PUBLIC", "BOOKS"), "BOOKS", "ID"));
        builder.findOrCreate("9_weak_self_reference");
        builder.clear();
        builder.addColumnReference(new WeakAssociationBuilder.WeakAssociationColumn((Schema)new SchemaReference("PRIVATE", "LIBRARY"), "BOOKS", "PREVIOUSEDITIONID"), new WeakAssociationBuilder.WeakAssociationColumn((Schema)new SchemaReference("PRIVATE", "LIBRARY"), "BOOKS", "ID"));
        builder.findOrCreate("10_weak_partial_self_reference");
        builder.clear();
        builder.addColumnReference(new WeakAssociationBuilder.WeakAssociationColumn(fkColumn), new WeakAssociationBuilder.WeakAssociationColumn(pkColumn));
        builder.findOrCreate("1_weak_duplicate");
        builder.clear();
        builder.addColumnReference(new WeakAssociationBuilder.WeakAssociationColumn((Schema)new SchemaReference("PUBLIC", "BOOKS"), "BOOKAUTHORS", "AUTHORID"), new WeakAssociationBuilder.WeakAssociationColumn(pkColumn));
        Optional optionalTableRef = builder.findOrCreate("12_same_as_fk");
        MatcherAssert.assertThat((Object)optionalTableRef, (Matcher)OptionalMatchers.isPresent());
        MatcherAssert.assertThat(optionalTableRef.get(), (Matcher)Matchers.instanceOf(ForeignKey.class));
        MatcherAssert.assertThat((Object)((TableReference)optionalTableRef.get()).getName(), (Matcher)Matchers.is((Object)"Z_FK_AUTHOR"));
        try (TestWriter out = testout = new TestWriter();){
            Schema[] schemas = this.catalog.getSchemas().toArray(new Schema[0]);
            MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)5));
            for (Schema schema : schemas) {
                Table[] tables;
                out.println("schema: " + schema.getFullName());
                for (Table table : tables = this.catalog.getTables(schema).toArray(new Table[0])) {
                    out.println("  table: " + table.getFullName());
                    for (WeakAssociation foreignKey : table.getWeakAssociations()) {
                        out.println("    weak association: " + foreignKey.getName());
                        out.println("      column references: ");
                        List columnReferences = foreignKey.getColumnReferences();
                        for (int i = 0; i < columnReferences.size(); ++i) {
                            ColumnReference columnReference = (ColumnReference)columnReferences.get(i);
                            out.println("        key sequence: " + (i + 1));
                            out.println("          " + columnReference);
                        }
                    }
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(testContext.testMethodFullName())));
    }
}

