/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.util.HashMap;
import java.util.function.BiConsumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import schemacrawler.schemacrawler.InfoLevel;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.schemacrawler.SchemaInfoRetrieval;

public class SchemaInfoLevelBuilderTest {
    @Test
    public void nullInfoLevel() {
        MatcherAssert.assertThat((Object)SchemaInfoLevelBuilder.builder().withInfoLevel(null).toOptions(), (Matcher)CoreMatchers.is((Object)SchemaInfoLevelBuilder.builder().toOptions()));
    }

    @Test
    public void prebuilt() {
        SchemaInfoLevel minimum = SchemaInfoLevelBuilder.minimum();
        MatcherAssert.assertThat((Object)minimum.getTag(), (Matcher)CoreMatchers.is((Object)"minimum"));
        MatcherAssert.assertThat((Object)minimum.is(SchemaInfoRetrieval.retrieveTables), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)minimum.is(SchemaInfoRetrieval.retrievePrimaryKeys), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)minimum.is(SchemaInfoRetrieval.retrieveRoutineInformation), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)minimum.is(SchemaInfoRetrieval.retrieveAdditionalColumnAttributes), (Matcher)CoreMatchers.is((Object)false));
        SchemaInfoLevel standard = SchemaInfoLevelBuilder.standard();
        MatcherAssert.assertThat((Object)standard.getTag(), (Matcher)CoreMatchers.is((Object)"standard"));
        MatcherAssert.assertThat((Object)standard.is(SchemaInfoRetrieval.retrieveTables), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)standard.is(SchemaInfoRetrieval.retrievePrimaryKeys), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)standard.is(SchemaInfoRetrieval.retrieveRoutineInformation), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)standard.is(SchemaInfoRetrieval.retrieveAdditionalColumnAttributes), (Matcher)CoreMatchers.is((Object)false));
        SchemaInfoLevel detailed = SchemaInfoLevelBuilder.detailed();
        MatcherAssert.assertThat((Object)detailed.getTag(), (Matcher)CoreMatchers.is((Object)"detailed"));
        MatcherAssert.assertThat((Object)detailed.is(SchemaInfoRetrieval.retrieveTables), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)detailed.is(SchemaInfoRetrieval.retrievePrimaryKeys), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)detailed.is(SchemaInfoRetrieval.retrieveRoutineInformation), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)detailed.is(SchemaInfoRetrieval.retrieveAdditionalColumnAttributes), (Matcher)CoreMatchers.is((Object)false));
        SchemaInfoLevel maximum = SchemaInfoLevelBuilder.maximum();
        MatcherAssert.assertThat((Object)maximum.getTag(), (Matcher)CoreMatchers.is((Object)"maximum"));
        MatcherAssert.assertThat((Object)maximum.is(SchemaInfoRetrieval.retrieveTables), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)maximum.is(SchemaInfoRetrieval.retrievePrimaryKeys), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)maximum.is(SchemaInfoRetrieval.retrieveRoutineInformation), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)maximum.is(SchemaInfoRetrieval.retrieveAdditionalColumnAttributes), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)SchemaInfoLevelBuilder.newSchemaInfoLevel(), (Matcher)CoreMatchers.is((Object)standard));
        MatcherAssert.assertThat((Object)standard.is(null), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void setRetrieveAdditionalColumnMetadata() {
        HashMap<SchemaInfoRetrieval, BiConsumer> testMap = new HashMap<SchemaInfoRetrieval, BiConsumer>();
        testMap.put(SchemaInfoRetrieval.retrieveAdditionalColumnAttributes, SchemaInfoLevelBuilder::setRetrieveAdditionalColumnAttributes);
        testMap.put(SchemaInfoRetrieval.retrieveAdditionalColumnMetadata, SchemaInfoLevelBuilder::setRetrieveAdditionalColumnMetadata);
        testMap.put(SchemaInfoRetrieval.retrieveAdditionalDatabaseInfo, SchemaInfoLevelBuilder::setRetrieveAdditionalDatabaseInfo);
        testMap.put(SchemaInfoRetrieval.retrieveAdditionalJdbcDriverInfo, SchemaInfoLevelBuilder::setRetrieveAdditionalJdbcDriverInfo);
        testMap.put(SchemaInfoRetrieval.retrieveAdditionalTableAttributes, SchemaInfoLevelBuilder::setRetrieveAdditionalTableAttributes);
        testMap.put(SchemaInfoRetrieval.retrieveColumnDataTypes, SchemaInfoLevelBuilder::setRetrieveColumnDataTypes);
        testMap.put(SchemaInfoRetrieval.retrieveDatabaseInfo, SchemaInfoLevelBuilder::setRetrieveDatabaseInfo);
        testMap.put(SchemaInfoRetrieval.retrieveDatabaseUsers, SchemaInfoLevelBuilder::setRetrieveDatabaseUsers);
        testMap.put(SchemaInfoRetrieval.retrievePrimaryKeys, SchemaInfoLevelBuilder::setRetrievePrimaryKeys);
        testMap.put(SchemaInfoRetrieval.retrieveForeignKeys, SchemaInfoLevelBuilder::setRetrieveForeignKeys);
        testMap.put(SchemaInfoRetrieval.retrieveIndexes, SchemaInfoLevelBuilder::setRetrieveIndexes);
        testMap.put(SchemaInfoRetrieval.retrieveIndexInformation, SchemaInfoLevelBuilder::setRetrieveIndexInformation);
        testMap.put(SchemaInfoRetrieval.retrieveRoutineInformation, SchemaInfoLevelBuilder::setRetrieveRoutineInformation);
        testMap.put(SchemaInfoRetrieval.retrieveRoutineParameters, SchemaInfoLevelBuilder::setRetrieveRoutineParameters);
        testMap.put(SchemaInfoRetrieval.retrieveRoutines, SchemaInfoLevelBuilder::setRetrieveRoutines);
        testMap.put(SchemaInfoRetrieval.retrieveSequenceInformation, SchemaInfoLevelBuilder::setRetrieveSequenceInformation);
        testMap.put(SchemaInfoRetrieval.retrieveServerInfo, SchemaInfoLevelBuilder::setRetrieveServerInfo);
        testMap.put(SchemaInfoRetrieval.retrieveSynonymInformation, SchemaInfoLevelBuilder::setRetrieveSynonymInformation);
        testMap.put(SchemaInfoRetrieval.retrieveTableColumnPrivileges, SchemaInfoLevelBuilder::setRetrieveTableColumnPrivileges);
        testMap.put(SchemaInfoRetrieval.retrieveTableColumns, SchemaInfoLevelBuilder::setRetrieveTableColumns);
        testMap.put(SchemaInfoRetrieval.retrieveTableConstraints, SchemaInfoLevelBuilder::setRetrieveTableConstraints);
        testMap.put(SchemaInfoRetrieval.retrieveTableConstraintDefinitions, SchemaInfoLevelBuilder::setRetrieveTableConstraintDefinitions);
        testMap.put(SchemaInfoRetrieval.retrieveTableConstraintInformation, SchemaInfoLevelBuilder::setRetrieveTableConstraintInformation);
        testMap.put(SchemaInfoRetrieval.retrieveTableDefinitionsInformation, SchemaInfoLevelBuilder::setRetrieveTableDefinitionsInformation);
        testMap.put(SchemaInfoRetrieval.retrieveTablePrivileges, SchemaInfoLevelBuilder::setRetrieveTablePrivileges);
        testMap.put(SchemaInfoRetrieval.retrieveTables, SchemaInfoLevelBuilder::setRetrieveTables);
        testMap.put(SchemaInfoRetrieval.retrieveTriggerInformation, SchemaInfoLevelBuilder::setRetrieveTriggerInformation);
        testMap.put(SchemaInfoRetrieval.retrieveUserDefinedColumnDataTypes, SchemaInfoLevelBuilder::setRetrieveUserDefinedColumnDataTypes);
        testMap.put(SchemaInfoRetrieval.retrieveViewInformation, SchemaInfoLevelBuilder::setRetrieveViewInformation);
        testMap.put(SchemaInfoRetrieval.retrieveViewTableUsage, SchemaInfoLevelBuilder::setRetrieveViewViewTableUsage);
        SchemaInfoLevelBuilder builder = SchemaInfoLevelBuilder.builder();
        testMap.forEach((infoRetrieval, consumer) -> {
            consumer.accept(builder, true);
            MatcherAssert.assertThat((String)("Failed for " + infoRetrieval), (Object)builder.toOptions().is(infoRetrieval), (Matcher)CoreMatchers.is((Object)true));
            consumer.accept(builder, false);
            MatcherAssert.assertThat((String)("Failed for " + infoRetrieval), (Object)builder.toOptions().is(infoRetrieval), (Matcher)CoreMatchers.is((Object)false));
        });
    }

    @Test
    public void tag() {
        SchemaInfoLevelBuilder builder = SchemaInfoLevelBuilder.builder();
        MatcherAssert.assertThat((Object)builder.toString(), (Matcher)Matchers.equalTo((Object)""));
        SchemaInfoLevel options = builder.toOptions();
        MatcherAssert.assertThat((Object)builder.toString(), (Matcher)Matchers.equalTo((Object)options.getTag()));
        MatcherAssert.assertThat((Object)options.getTag(), (Matcher)Matchers.equalTo((Object)""));
        MatcherAssert.assertThat((Object)options.toString().replaceAll(System.lineSeparator(), "\n"), (Matcher)CoreMatchers.startsWith((String)"{"));
        builder.withInfoLevel(InfoLevel.standard);
        options = builder.toOptions();
        MatcherAssert.assertThat((Object)builder.toString(), (Matcher)Matchers.equalTo((Object)options.getTag()));
        MatcherAssert.assertThat((Object)options.getTag(), (Matcher)Matchers.equalTo((Object)"standard"));
        MatcherAssert.assertThat((Object)options.toString().replaceAll(System.lineSeparator(), ""), (Matcher)CoreMatchers.is((Object)"{  \"retrieveAdditionalColumnAttributes\": false,  \"retrieveAdditionalColumnMetadata\": false,  \"retrieveAdditionalDatabaseInfo\": false,  \"retrieveAdditionalJdbcDriverInfo\": false,  \"retrieveAdditionalTableAttributes\": false,  \"retrieveColumnDataTypes\": true,  \"retrieveDatabaseInfo\": true,  \"retrieveDatabaseUsers\": false,  \"retrieveForeignKeys\": true,  \"retrieveIndexInformation\": false,  \"retrieveIndexes\": true,  \"retrievePrimaryKeys\": true,  \"retrieveRoutineInformation\": false,  \"retrieveRoutineParameters\": true,  \"retrieveRoutines\": true,  \"retrieveSequenceInformation\": false,  \"retrieveServerInfo\": false,  \"retrieveSynonymInformation\": false,  \"retrieveTableColumnPrivileges\": false,  \"retrieveTableColumns\": true,  \"retrieveTableConstraintDefinitions\": false,  \"retrieveTableConstraintInformation\": false,  \"retrieveTableConstraints\": false,  \"retrieveTableDefinitionsInformation\": false,  \"retrieveTablePrivileges\": false,  \"retrieveTables\": true,  \"retrieveTriggerInformation\": false,  \"retrieveUserDefinedColumnDataTypes\": false,  \"retrieveViewInformation\": false,  \"retrieveViewTableUsage\": false}"));
        builder.withTag("custom");
        options = builder.toOptions();
        MatcherAssert.assertThat((Object)builder.toString(), (Matcher)Matchers.equalTo((Object)options.getTag()));
        MatcherAssert.assertThat((Object)options.getTag(), (Matcher)Matchers.equalTo((Object)"custom"));
        MatcherAssert.assertThat((Object)options.toString().replaceAll(System.lineSeparator(), ""), (Matcher)CoreMatchers.is((Object)"{  \"retrieveAdditionalColumnAttributes\": false,  \"retrieveAdditionalColumnMetadata\": false,  \"retrieveAdditionalDatabaseInfo\": false,  \"retrieveAdditionalJdbcDriverInfo\": false,  \"retrieveAdditionalTableAttributes\": false,  \"retrieveColumnDataTypes\": true,  \"retrieveDatabaseInfo\": true,  \"retrieveDatabaseUsers\": false,  \"retrieveForeignKeys\": true,  \"retrieveIndexInformation\": false,  \"retrieveIndexes\": true,  \"retrievePrimaryKeys\": true,  \"retrieveRoutineInformation\": false,  \"retrieveRoutineParameters\": true,  \"retrieveRoutines\": true,  \"retrieveSequenceInformation\": false,  \"retrieveServerInfo\": false,  \"retrieveSynonymInformation\": false,  \"retrieveTableColumnPrivileges\": false,  \"retrieveTableColumns\": true,  \"retrieveTableConstraintDefinitions\": false,  \"retrieveTableConstraintInformation\": false,  \"retrieveTableConstraints\": false,  \"retrieveTableDefinitionsInformation\": false,  \"retrieveTablePrivileges\": false,  \"retrieveTables\": true,  \"retrieveTriggerInformation\": false,  \"retrieveUserDefinedColumnDataTypes\": false,  \"retrieveViewInformation\": false,  \"retrieveViewTableUsage\": false}"));
        builder.withTag("\t\t");
        options = builder.toOptions();
        MatcherAssert.assertThat((Object)builder.toString(), (Matcher)Matchers.equalTo((Object)options.getTag()));
        MatcherAssert.assertThat((Object)options.getTag(), (Matcher)Matchers.equalTo((Object)""));
    }

    @Test
    public void testFromOptions() {
        SchemaInfoLevel options0 = SchemaInfoLevelBuilder.builder().toOptions();
        SchemaInfoLevel options1 = SchemaInfoLevelBuilder.standard();
        SchemaInfoLevel options2 = SchemaInfoLevelBuilder.builder().fromOptions(options1).toOptions();
        SchemaInfoLevel options3 = SchemaInfoLevelBuilder.builder().fromOptions(null).toOptions();
        SchemaInfoLevel options4 = SchemaInfoLevelBuilder.builder().withTag("custom").toOptions();
        MatcherAssert.assertThat((Object)options0, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)options1)));
        MatcherAssert.assertThat((Object)options0, (Matcher)Matchers.equalTo((Object)options3));
        MatcherAssert.assertThat((Object)options0, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)options4)));
        MatcherAssert.assertThat((Object)options1, (Matcher)Matchers.equalTo((Object)options2));
        MatcherAssert.assertThat((Object)options1, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)options4)));
    }

    @Test
    public void without() {
        SchemaInfoLevelBuilder builder = SchemaInfoLevelBuilder.builder().withInfoLevel(InfoLevel.standard);
        SchemaInfoLevel options = builder.toOptions();
        MatcherAssert.assertThat((Object)options.is(SchemaInfoRetrieval.retrieveTables), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)options.is(SchemaInfoRetrieval.retrieveRoutines), (Matcher)Matchers.equalTo((Object)true));
        builder.withoutTables().withoutRoutines();
        options = builder.toOptions();
        MatcherAssert.assertThat((Object)options.is(SchemaInfoRetrieval.retrieveTables), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)options.is(SchemaInfoRetrieval.retrieveRoutines), (Matcher)Matchers.equalTo((Object)false));
    }
}

