/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.io.Serializable;
import java.sql.Connection;
import org.apache.commons.lang3.SerializationUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.WithTestDatabase;

@WithTestDatabase
public class SerializationTest {
    @Test
    public void catalogSerialization(Connection connection) throws Exception {
        SchemaCrawlerOptions schemaCrawlerOptions = DatabaseTestUtility.schemaCrawlerOptionsWithMaximumSchemaInfoLevel;
        Catalog catalog = DatabaseTestUtility.getCatalog(connection, schemaCrawlerOptions);
        MatcherAssert.assertThat((String)"Could not obtain catalog", (Object)catalog, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"Could not find any schemas", (Object)catalog.getSchemas(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        Schema schema = catalog.lookupSchema("PUBLIC.BOOKS").orElse(null);
        MatcherAssert.assertThat((String)"Could not obtain schema", (Object)schema, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"Unexpected number of tables in the schema", (Object)catalog.getTables(schema), (Matcher)Matchers.hasSize((int)10));
        Catalog clonedCatalog = (Catalog)SerializationUtils.clone((Serializable)catalog);
        MatcherAssert.assertThat((Object)catalog, (Matcher)Matchers.equalTo((Object)clonedCatalog));
        MatcherAssert.assertThat((String)"Could not obtain catalog", (Object)clonedCatalog, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"Could not find any schemas", (Object)clonedCatalog.getSchemas(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        Schema clonedSchema = clonedCatalog.lookupSchema("PUBLIC.BOOKS").orElse(null);
        MatcherAssert.assertThat((String)"Could not obtain schema", (Object)clonedSchema, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"Unexpected number of tables in the schema", (Object)clonedCatalog.getTables(clonedSchema), (Matcher)Matchers.hasSize((int)10));
    }
}

