/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.sql.Connection;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Index;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.WithTestDatabase;
import schemacrawler.utility.NamedObjectSort;

@WithTestDatabase
public class SortingTest {
    @Test
    public void columnSort(Connection connection) throws Exception {
        String[] sortedNatural = new String[]{"ID", "FIRSTNAME", "LASTNAME", "ADDRESS1", "ADDRESS2", "CITY", "STATE", "POSTALCODE", "COUNTRY"};
        Object[] sortedAlpha = Arrays.copyOf(sortedNatural, sortedNatural.length);
        Arrays.sort(sortedAlpha);
        this.checkColumnSort(connection, "AUTHORS", (String[])sortedAlpha, true);
        this.checkColumnSort(connection, "AUTHORS", sortedNatural, false);
    }

    @Test
    public void fkSort(Connection connection) throws Exception {
        String[] sortedNatural = new String[]{"Z_FK_AUTHOR", "SYS_FK_10120"};
        Object[] sortedAlpha = Arrays.copyOf(sortedNatural, sortedNatural.length);
        Arrays.sort(sortedAlpha);
        this.checkFkSort(connection, "BOOKAUTHORS", (String[])sortedAlpha, true);
        this.checkFkSort(connection, "BOOKAUTHORS", sortedNatural, false);
    }

    @Test
    public void indexSort(Connection connection) throws Exception {
        String[] sortedNatural = new String[]{"PK_AUTHORS", "IDX_B_AUTHORS", "IDX_A_AUTHORS"};
        Object[] sortedAlpha = Arrays.copyOf(sortedNatural, sortedNatural.length);
        Arrays.sort(sortedAlpha);
        this.checkIndexSort(connection, "AUTHORS", (String[])sortedAlpha, true);
        this.checkIndexSort(connection, "AUTHORS", sortedNatural, false);
    }

    private void checkColumnSort(Connection connection, String tableName, String[] expectedValues, boolean sortAlphabetically) throws Exception {
        SchemaCrawlerOptions schemaCrawlerOptions = DatabaseTestUtility.schemaCrawlerOptionsWithMaximumSchemaInfoLevel;
        Catalog catalog = DatabaseTestUtility.getCatalog(connection, schemaCrawlerOptions);
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        MatcherAssert.assertThat((String)"Schema not found", (Object)schema, (Matcher)Matchers.notNullValue());
        Table table = catalog.lookupTable((Schema)schema, tableName).orElse(null);
        MatcherAssert.assertThat((String)("Table " + tableName + " not found"), (Object)table, (Matcher)Matchers.notNullValue());
        if (table.getName().equals(tableName)) {
            Column[] columns = table.getColumns().toArray(new Column[0]);
            Arrays.sort(columns, NamedObjectSort.getNamedObjectSort((boolean)sortAlphabetically));
            MatcherAssert.assertThat((String)"Column count does not match", (Object)expectedValues.length, (Matcher)Matchers.equalTo((Object)columns.length));
            for (int i = 0; i < columns.length; ++i) {
                Column column = columns[i];
                MatcherAssert.assertThat((String)("Columns not " + (sortAlphabetically ? "alphabetically" : "naturally") + " sorted"), (Object)expectedValues[i], (Matcher)Matchers.equalTo((Object)column.getName()));
            }
        }
    }

    private void checkFkSort(Connection connection, String tableName, String[] expectedValues, boolean sortAlphabetically) throws Exception {
        SchemaCrawlerOptions schemaCrawlerOptions = DatabaseTestUtility.schemaCrawlerOptionsWithMaximumSchemaInfoLevel;
        Catalog catalog = DatabaseTestUtility.getCatalog(connection, schemaCrawlerOptions);
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        MatcherAssert.assertThat((String)"Schema not found", (Object)schema, (Matcher)Matchers.notNullValue());
        Table[] tables = catalog.getTables((Schema)schema).toArray(new Table[0]);
        MatcherAssert.assertThat((String)"Table count does not match", (Object)tables, (Matcher)Matchers.arrayWithSize((int)10));
        for (Table table : tables) {
            if (!table.getName().equals(tableName)) continue;
            ForeignKey[] foreignKeys = table.getForeignKeys().toArray(new ForeignKey[0]);
            Arrays.sort(foreignKeys, NamedObjectSort.getNamedObjectSort((boolean)sortAlphabetically));
            MatcherAssert.assertThat((String)"Foreign key count does not match", (Object)expectedValues.length, (Matcher)Matchers.equalTo((Object)foreignKeys.length));
            for (int i = 0; i < foreignKeys.length; ++i) {
                ForeignKey foreignKey = foreignKeys[i];
                MatcherAssert.assertThat((String)("Foreign keys not " + (sortAlphabetically ? "alphabetically" : "naturally") + " sorted"), (Object)expectedValues[i], (Matcher)Matchers.equalTo((Object)foreignKey.getName()));
            }
        }
    }

    private void checkIndexSort(Connection connection, String tableName, String[] expectedValues, boolean sortAlphabetically) throws Exception {
        SchemaCrawlerOptions schemaCrawlerOptions = DatabaseTestUtility.schemaCrawlerOptionsWithMaximumSchemaInfoLevel;
        Catalog catalog = DatabaseTestUtility.getCatalog(connection, schemaCrawlerOptions);
        SchemaReference schema = new SchemaReference("PUBLIC", "BOOKS");
        Table[] tables = catalog.getTables((Schema)schema).toArray(new Table[0]);
        MatcherAssert.assertThat((String)"Table count does not match", (Object)tables, (Matcher)Matchers.arrayWithSize((int)10));
        for (Table table : tables) {
            if (!table.getName().equals(tableName)) continue;
            Index[] indexes = table.getIndexes().toArray(new Index[0]);
            Arrays.sort(indexes, NamedObjectSort.getNamedObjectSort((boolean)sortAlphabetically));
            MatcherAssert.assertThat((String)("Index count does not match for table " + table), (Object)expectedValues.length, (Matcher)Matchers.equalTo((Object)indexes.length));
            for (int i = 0; i < indexes.length; ++i) {
                Index index = indexes[i];
                MatcherAssert.assertThat((String)("Indexes not " + (sortAlphabetically ? "alphabetically" : "naturally") + " sorted  for table " + table), (Object)expectedValues[i], (Matcher)Matchers.equalTo((Object)index.getName()));
            }
        }
    }
}

