/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.number.OrderingComparison;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import schemacrawler.schema.TableType;

public class TableTypeTest {
    @Test
    public void tableTypeCompare0() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TableType(null));
    }

    @Test
    public void tableTypeCompare1() throws Exception {
        TableType tableType1 = new TableType("table");
        TableType tableType2 = new TableType("table");
        MatcherAssert.assertThat((Object)tableType1, (Matcher)OrderingComparison.comparesEqualTo((Comparable)tableType2));
        MatcherAssert.assertThat((Object)tableType2, (Matcher)OrderingComparison.comparesEqualTo((Comparable)tableType1));
        MatcherAssert.assertThat((Object)tableType1, (Matcher)Matchers.equalTo((Object)tableType2));
    }

    @Test
    public void tableTypeCompare2() throws Exception {
        TableType tableType1 = new TableType("table");
        TableType tableType2 = new TableType("materialized view");
        MatcherAssert.assertThat((Object)tableType1, (Matcher)OrderingComparison.lessThan((Comparable)tableType2));
        MatcherAssert.assertThat((Object)tableType2, (Matcher)OrderingComparison.greaterThan((Comparable)tableType1));
    }

    @Test
    public void tableTypeCompare3() throws Exception {
        TableType tableType1 = new TableType("view");
        TableType tableType2 = new TableType("materialized view");
        MatcherAssert.assertThat((Object)tableType1, (Matcher)OrderingComparison.lessThan((Comparable)tableType2));
        MatcherAssert.assertThat((Object)tableType2, (Matcher)OrderingComparison.greaterThan((Comparable)tableType1));
    }

    @Test
    public void tableTypeCompare4() throws Exception {
        TableType tableType1 = new TableType("table");
        TableType tableType2 = new TableType("view");
        MatcherAssert.assertThat((Object)tableType1, (Matcher)OrderingComparison.lessThan((Comparable)tableType2));
        MatcherAssert.assertThat((Object)tableType2, (Matcher)OrderingComparison.greaterThan((Comparable)tableType1));
    }
}

