/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.sql.Connection;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionExclusionRule;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.FileHasContent;
import schemacrawler.test.utility.TestWriter;
import schemacrawler.test.utility.WithTestDatabase;
import schemacrawler.utility.NamedObjectSort;

@WithTestDatabase
public class TableTypesTest {
    private static final String TABLE_TYPES_OUTPUT = "table_types/";

    @Test
    public void all(Connection connection) throws Exception {
        this.test(connection, "all.txt", null);
    }

    @Test
    public void bad(Connection connection) throws Exception {
        this.test(connection, "bad.txt", "BAD TABLE TYPE");
    }

    @Test
    public void defaultTableTypes(Connection connection) throws Exception {
        this.test(connection, "default.txt", "default");
    }

    @Test
    public void global_temporary(Connection connection) throws Exception {
        this.test(connection, "global_temporary.txt", "GLOBAL TEMPORARY");
    }

    @Test
    public void mixed(Connection connection) throws Exception {
        this.test(connection, "mixed.txt", " global temporary, view ");
    }

    @Test
    public void none(Connection connection) throws Exception {
        this.test(connection, "none.txt", "");
    }

    @Test
    public void system(Connection connection) throws Exception {
        this.test(connection, "system.txt", "SYSTEM TABLE");
    }

    @Test
    public void tables(Connection connection) throws Exception {
        this.test(connection, "tables.txt", "TABLE");
    }

    @Test
    public void views(Connection connection) throws Exception {
        this.test(connection, "views.txt", "VIEW");
    }

    private void test(Connection connection, String referenceFile, String tableTypes) throws Exception {
        TestWriter testout;
        try (TestWriter out = testout = new TestWriter();){
            LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().includeSchemas((InclusionRule)new RegularExpressionExclusionRule(".*\\.FOR_LINT"));
            if (!"default".equals(tableTypes)) {
                limitOptionsBuilder.tableTypes(tableTypes);
            }
            SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptionsBuilder.toOptions());
            Catalog catalog = DatabaseTestUtility.getCatalog(connection, schemaCrawlerOptions);
            Schema[] schemas = catalog.getSchemas().toArray(new Schema[0]);
            MatcherAssert.assertThat((String)"Schema count does not match", (Object)schemas, (Matcher)Matchers.arrayWithSize((int)5));
            for (Schema schema : schemas) {
                out.println(String.format("%s", schema.getFullName()));
                Table[] tables = catalog.getTables(schema).toArray(new Table[0]);
                Arrays.sort(tables, NamedObjectSort.alphabetical);
                for (Table table : tables) {
                    out.println(String.format("  %s [%s]", table.getName(), table.getTableType()));
                    Object[] columns = table.getColumns().toArray(new Column[0]);
                    Arrays.sort(columns);
                    for (Object column : columns) {
                        out.println(String.format("    %s [%s]", column.getName(), column.getColumnDataType()));
                    }
                }
            }
        }
        MatcherAssert.assertThat((Object)FileHasContent.outputOf(testout), FileHasContent.hasSameContentAs(FileHasContent.classpathResource(TABLE_TYPES_OUTPUT + referenceFile)));
    }
}

