/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.keyvalue.UnmodifiableMapEntry;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import schemacrawler.utility.TypeMap;

public class TypeMapTest {
    @Test
    public void typeMap() throws Exception {
        TypeMap typeMap = new TypeMap();
        MatcherAssert.assertThat((Object)typeMap.get((Object)"VARCHAR"), (Matcher)CoreMatchers.is(String.class));
        MatcherAssert.assertThat((Object)typeMap.get((Object)"BAD_TYPE"), (Matcher)CoreMatchers.is(Object.class));
        MatcherAssert.assertThat((Object)typeMap.size(), (Matcher)CoreMatchers.is((Object)39));
    }

    @Test
    public void typeMapConnection() throws Exception {
        HashMap<String, Class> map = new HashMap<String, Class>();
        map.put("string", String.class);
        map.put("object", Object.class);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        TypeMap typeMap1 = new TypeMap(connection);
        MatcherAssert.assertThat((Object)typeMap1.size(), (Matcher)CoreMatchers.is((Object)39));
        Mockito.when(connection.getTypeMap()).thenReturn(null);
        TypeMap typeMap2 = new TypeMap(connection);
        MatcherAssert.assertThat((Object)typeMap2.size(), (Matcher)CoreMatchers.is((Object)39));
        Mockito.when(connection.getTypeMap()).thenReturn(new HashMap());
        TypeMap typeMap3 = new TypeMap(connection);
        MatcherAssert.assertThat((Object)typeMap3.size(), (Matcher)CoreMatchers.is((Object)39));
        Mockito.when(connection.getTypeMap()).thenReturn(map);
        TypeMap typeMap4 = new TypeMap(connection);
        MatcherAssert.assertThat((Object)typeMap4.size(), (Matcher)CoreMatchers.is((Object)41));
        TypeMap typeMap5 = new TypeMap((Connection)null);
        MatcherAssert.assertThat((Object)typeMap5.size(), (Matcher)CoreMatchers.is((Object)39));
        Mockito.when(connection.getTypeMap()).thenThrow(IllegalArgumentException.class);
        TypeMap typeMap6 = new TypeMap(connection);
        MatcherAssert.assertThat((Object)typeMap6.size(), (Matcher)CoreMatchers.is((Object)39));
    }

    @Test
    public void typeMapTests() throws Exception {
        HashMap<String, Class> map = new HashMap<String, Class>();
        map.put("string", String.class);
        map.put("object", Object.class);
        TypeMap typeMap = new TypeMap(map);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> typeMap.clear());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> typeMap.put("long", Long.class));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> typeMap.putAll(map));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> typeMap.remove((Object)"int"));
        MatcherAssert.assertThat((Object)typeMap.get((Object)"string"), (Matcher)CoreMatchers.is(String.class));
        MatcherAssert.assertThat((Object)typeMap.get((Object)"long"), (Matcher)CoreMatchers.is(Object.class));
        MatcherAssert.assertThat((Object)typeMap.containsKey((Object)"string"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)typeMap.containsKey((Object)"long"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)typeMap.containsValue(String.class), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)typeMap.containsValue(Long.class), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)typeMap.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"string", "object"}));
        MatcherAssert.assertThat((Object)typeMap.values(), (Matcher)Matchers.containsInAnyOrder((Object[])new Class[]{String.class, Object.class}));
        MatcherAssert.assertThat((Object)typeMap.entrySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new Map.Entry[]{new UnmodifiableMapEntry((Object)"string", String.class), new UnmodifiableMapEntry((Object)"object", Object.class)}));
        MatcherAssert.assertThat((Object)typeMap.toString(), (Matcher)CoreMatchers.is((Object)"{string=java.lang.String, object=java.lang.Object}"));
        MatcherAssert.assertThat((Object)typeMap.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)typeMap.hashCode(), (Matcher)CoreMatchers.is((Object)map.hashCode()));
        MatcherAssert.assertThat((Object)typeMap, (Matcher)CoreMatchers.is(map));
        MatcherAssert.assertThat((Object)new TypeMap((Map)null).isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)new TypeMap(new HashMap()).isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }
}

