/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

final class AssertNoSystemErrOutputExtension
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private static final String DEFAULT_CHARSET = Charset.defaultCharset().name();
    private ByteArrayOutputStream err;

    AssertNoSystemErrOutputExtension() {
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        System.err.flush();
        System.setErr(new PrintStream((OutputStream)new FileOutputStream(FileDescriptor.err), true, DEFAULT_CHARSET));
        this.err.close();
        String output = this.err.toString();
        this.err = null;
        MatcherAssert.assertThat((String)"Expected no System.err output", (Object)output, (Matcher)Matchers.is((Matcher)Matchers.emptyString()));
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        if (this.err != null) {
            Assertions.fail((String)"STDERR CORRUPTION");
        }
        this.err = new ByteArrayOutputStream();
        System.err.flush();
        System.setErr(new PrintStream((OutputStream)this.err, true, DEFAULT_CHARSET));
    }
}

