/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

final class AssertNoSystemOutOutputExtension
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private static final String DEFAULT_CHARSET = Charset.defaultCharset().name();
    private ByteArrayOutputStream out;

    AssertNoSystemOutOutputExtension() {
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        System.out.flush();
        System.setOut(new PrintStream((OutputStream)new FileOutputStream(FileDescriptor.out), true, DEFAULT_CHARSET));
        this.out.close();
        String output = this.out.toString();
        this.out = null;
        MatcherAssert.assertThat((String)"Expected no System.out output", (Object)output, (Matcher)Matchers.is((Matcher)Matchers.emptyString()));
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        if (this.out != null) {
            Assertions.fail((String)"STDOUT CORRUPTION");
        }
        this.out = new ByteArrayOutputStream();
        System.out.flush();
        System.setOut(new PrintStream((OutputStream)this.out, true, DEFAULT_CHARSET));
    }
}

