/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import schemacrawler.test.utility.CapturedLogs;

final class CaptureLogsExtension
implements ParameterResolver,
BeforeEachCallback,
AfterEachCallback {
    private static final Level MAXIMUM_LEVEL = Level.CONFIG;
    private CapturedLogs logs;

    CaptureLogsExtension() {
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.logs.close();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.logs = new CapturedLogs();
        this.applyApplicationLogLevel(MAXIMUM_LEVEL);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.logs;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        return parameter.getType().equals(CapturedLogs.class);
    }

    private void applyApplicationLogLevel(Level logLevel) {
        Objects.requireNonNull(logLevel, "No log level provided");
        LogManager logManager = LogManager.getLogManager();
        ArrayList<String> loggerNames = Collections.list(logManager.getLoggerNames());
        for (String loggerName : loggerNames) {
            Logger logger = logManager.getLogger(loggerName);
            if (logger == null) continue;
            for (Handler handler : logger.getHandlers()) {
                logger.removeHandler(handler);
            }
            if (loggerName.startsWith("schemacrawler.") || loggerName.startsWith("us.fatehi.")) {
                logger.setLevel(logLevel);
                logger.addHandler(this.logs);
                continue;
            }
            logger.setLevel(Level.OFF);
        }
        Logger rootLogger = Logger.getLogger("");
        rootLogger.setLevel(logLevel);
    }
}

