/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Parameter;
import java.nio.charset.Charset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import schemacrawler.test.utility.CapturedSystemStreams;
import schemacrawler.test.utility.TestOutputStream;

final class CaptureSystemStreamsExtension
implements ParameterResolver,
BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private static final String DEFAULT_CHARSET = Charset.defaultCharset().name();
    private TestOutputStream err;
    private TestOutputStream out;

    CaptureSystemStreamsExtension() {
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        System.out.flush();
        System.setOut(new PrintStream((OutputStream)new FileOutputStream(FileDescriptor.out), true, DEFAULT_CHARSET));
        this.out = null;
        System.err.flush();
        System.setErr(new PrintStream((OutputStream)new FileOutputStream(FileDescriptor.err), true, DEFAULT_CHARSET));
        this.err = null;
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        if (this.err != null) {
            Assertions.fail((String)"STDERR CORRUPTION");
        }
        if (this.out != null) {
            Assertions.fail((String)"STDOUT CORRUPTION");
        }
        this.out = new TestOutputStream();
        this.err = new TestOutputStream();
        System.out.flush();
        System.setOut(new PrintStream((OutputStream)this.out, true, DEFAULT_CHARSET));
        System.err.flush();
        System.setErr(new PrintStream((OutputStream)this.err, true, DEFAULT_CHARSET));
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        if (this.isSystemStreamParameter(parameter)) {
            return new CapturedSystemStreams(this.out, this.err);
        }
        throw new ParameterResolutionException("Could not resolve " + parameter);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        return this.isSystemStreamParameter(parameter);
    }

    private boolean isSystemStreamParameter(Parameter parameter) {
        return parameter.getType().equals(CapturedSystemStreams.class);
    }
}

