/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class DOCTYPEChanger
extends FilterReader {
    protected boolean replace = true;
    protected String rootElement;
    protected String publicIdentifier = "";
    protected String systemIdentifier = "";
    protected String internalSubsetContent = "";
    protected boolean docStarted = false;
    protected boolean generating = false;
    protected boolean cycle = true;
    protected boolean internalSubset = false;
    protected StringBuilder myBuffer = new StringBuilder();
    private boolean endOfStream = false;

    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                throw new IllegalArgumentException("Wrong number of arguments");
            }
            DOCTYPEChanger tester = new DOCTYPEChanger(new FileReader(args[0]));
            tester.setRootElement("html");
            tester.setSystemIdentifier("http://www.simonstl.com/html");
            tester.setPublicIdentifier("-//SIMONSTLCOM//DTD tester//EN");
            tester.setInternalSubset("this is a test");
            tester.setReplace(false);
            try (BufferedReader in = new BufferedReader(tester);){
                String line;
                while ((line = in.readLine()) != null) {
                    System.out.println(line);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Usage: java DOCTYPEChanger <filename>");
        }
    }

    public DOCTYPEChanger(InputStream in) {
        this(new InputStreamReader(in));
    }

    public DOCTYPEChanger(Reader in) {
        super(new BufferedReader(in));
    }

    public String getInternalSubset() {
        return this.internalSubsetContent;
    }

    public String getPublicIdentifier() {
        return this.publicIdentifier;
    }

    public String getRootElement() {
        return this.rootElement;
    }

    public String getSystemIdentifier() {
        return this.systemIdentifier;
    }

    @Override
    public int read() throws IOException {
        int c = 32;
        if (this.myBuffer.length() == 0) {
            c = this.in.read();
            if (c == 60 && !this.docStarted) {
                int d = this.in.read();
                switch (d) {
                    case 63: {
                        this.myBuffer.append((char)d);
                        break;
                    }
                    case 33: {
                        int e = this.in.read();
                        if (e == 68) {
                            if (this.replace) {
                                while (this.cycle) {
                                    e = this.in.read();
                                    if (e == 91) {
                                        this.internalSubset = true;
                                    }
                                    if (e == 62 && !this.internalSubset) {
                                        this.addDocType();
                                        this.cycle = false;
                                    }
                                    if (e != 93) continue;
                                    this.internalSubset = false;
                                }
                            } else {
                                this.myBuffer.append((char)d);
                                this.myBuffer.append((char)e);
                            }
                            this.docStarted = true;
                            break;
                        }
                        this.myBuffer.append((char)d);
                        this.myBuffer.append((char)e);
                        break;
                    }
                    default: {
                        this.addDocType();
                        this.myBuffer.append("<");
                        this.myBuffer.append((char)d);
                        this.docStarted = true;
                        break;
                    }
                }
            }
        } else {
            c = this.feedFromInternalBuffer();
        }
        return c;
    }

    @Override
    public int read(char[] text, int offset, int length) throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        int numRead = 0;
        for (int i = offset; i < offset + length; ++i) {
            int temp = this.read();
            if (temp == -1) {
                this.endOfStream = true;
                break;
            }
            text[i] = (char)temp;
            ++numRead;
        }
        return numRead;
    }

    public void setInternalSubset(String subsetContents) {
        this.internalSubsetContent = subsetContents;
    }

    public void setPublicIdentifier(String identifier) {
        this.publicIdentifier = identifier;
    }

    public void setReplace(boolean replaceChoice) {
        this.replace = replaceChoice;
    }

    public void setRootElement(String elementName) {
        this.rootElement = elementName;
    }

    public void setSystemIdentifier(String identifier) {
        this.systemIdentifier = identifier;
    }

    protected void addDocType() {
        this.myBuffer.append("!DOCTYPE ");
        this.myBuffer.append(this.rootElement);
        if (this.publicIdentifier.equals("")) {
            if (!this.systemIdentifier.equals("")) {
                this.myBuffer.append(" SYSTEM '");
                this.myBuffer.append(this.systemIdentifier);
                this.myBuffer.append("'");
            }
        } else {
            this.myBuffer.append(" PUBLIC '");
            this.myBuffer.append(this.publicIdentifier);
            this.myBuffer.append("' '");
            this.myBuffer.append(this.systemIdentifier);
            this.myBuffer.append("'");
        }
        this.myBuffer.append(" ");
        if (!this.internalSubsetContent.equals("")) {
            this.myBuffer.append(" [\n");
            this.myBuffer.append(this.internalSubsetContent);
            this.myBuffer.append("\n]");
        }
        this.myBuffer.append(">\n");
        this.docStarted = true;
    }

    protected int feedFromInternalBuffer() {
        char retChar = this.myBuffer.charAt(0);
        this.myBuffer.reverse();
        this.myBuffer.setLength(this.myBuffer.length() - 1);
        this.myBuffer.reverse();
        return retChar;
    }
}

