/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.io.Serializable;
import us.fatehi.utility.Utility;

public class DatabaseConnectionInfo
implements Serializable {
    private static final long serialVersionUID = 3513025340881301828L;
    private final String host;
    private final int port;
    private final String database;
    private final String url;

    public DatabaseConnectionInfo(String host, int port, String database, String url) {
        this.host = Utility.requireNotBlank((String)host, (String)"No host provided");
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Bad port number provided, " + port);
        }
        this.port = port;
        this.database = Utility.requireNotBlank((String)database, (String)"No database provided");
        this.url = Utility.requireNotBlank((String)url, (String)"No url provided");
    }

    public String getConnectionUrl() {
        return this.url;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

