/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.io.IOException;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.Map;
import java.util.Properties;
import schemacrawler.crawl.SchemaCrawler;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.LoadOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.test.utility.TestUtility;
import us.fatehi.utility.PropertiesUtility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.DatabaseConnectionSourceUtility;
import us.fatehi.utility.ioresource.ClasspathInputResource;
import us.fatehi.utility.ioresource.InputResource;

public final class DatabaseTestUtility {
    public static final SchemaRetrievalOptions schemaRetrievalOptionsDefault = SchemaRetrievalOptionsBuilder.newSchemaRetrievalOptions();
    public static final SchemaCrawlerOptions schemaCrawlerOptionsWithMaximumSchemaInfoLevel = DatabaseTestUtility.getMaximumSchemaCrawlerOptions();

    public static Catalog getCatalog(Connection connection, SchemaCrawlerOptions schemaCrawlerOptions) {
        return DatabaseTestUtility.getCatalog(connection, schemaRetrievalOptionsDefault, schemaCrawlerOptions);
    }

    public static Catalog getCatalog(Connection connection, SchemaRetrievalOptions schemaRetrievalOptions, SchemaCrawlerOptions schemaCrawlerOptions) {
        DatabaseConnectionSource dataSource = DatabaseConnectionSourceUtility.newTestDatabaseConnectionSource(connection);
        SchemaCrawler schemaCrawler = new SchemaCrawler(dataSource, schemaRetrievalOptions, schemaCrawlerOptions);
        Catalog catalog = schemaCrawler.crawl();
        return catalog;
    }

    public static Map<String, String> loadHsqldbConfig() throws IOException {
        Properties properties = TestUtility.loadProperties((InputResource)new ClasspathInputResource("/hsqldb.INFORMATION_SCHEMA.config.properties"));
        return PropertiesUtility.propertiesMap((Properties)properties);
    }

    public static Path tempHsqldbConfig() throws IOException {
        Properties properties = TestUtility.loadProperties((InputResource)new ClasspathInputResource("/hsqldb.INFORMATION_SCHEMA.config.properties"));
        return TestUtility.savePropertiesToTempFile(properties);
    }

    private static SchemaCrawlerOptions getMaximumSchemaCrawlerOptions() {
        LoadOptionsBuilder loadOptionsBuilder = LoadOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.maximum());
        return SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLoadOptions(loadOptionsBuilder.toOptions());
    }

    private DatabaseTestUtility() {
    }
}

