/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Assertions;
import schemacrawler.test.utility.TestOutputCapture;
import schemacrawler.test.utility.TestResource;
import schemacrawler.test.utility.TestUtility;
import us.fatehi.utility.Utility;

public class FileHasContent
extends BaseMatcher<TestResource> {
    private final TestResource referenceFileResource;
    private final String outputFormatValue;
    private List<String> failures;

    public static TestResource classpathResource(String classpathResource) {
        Objects.requireNonNull(classpathResource, "No classpath resource provided");
        return new TestResource("/" + classpathResource);
    }

    public static String contentsOf(TestOutputCapture testoutput) {
        Objects.requireNonNull(testoutput, "No test output capture provided");
        return testoutput.getContents();
    }

    public static Matcher<TestResource> hasNoContent() {
        return new FileHasContent(null, null);
    }

    public static Matcher<TestResource> hasSameContentAndTypeAs(TestResource classpathTestResource, String outputFormatValue) {
        return FileHasContent.hasSameContentAndTypeAs(classpathTestResource, outputFormatValue, true);
    }

    public static Matcher<TestResource> hasSameContentAs(TestResource classpathTestResource) {
        return FileHasContent.hasSameContentAndTypeAs(classpathTestResource, null, false);
    }

    public static Matcher<TestResource> hasSameContentAsClasspathResource(String classpathTestResource) {
        return FileHasContent.hasSameContentAndTypeAs(new TestResource(classpathTestResource), null, false);
    }

    public static TestResource outputOf(Path filePath) {
        if (filePath == null) {
            return new TestResource();
        }
        return new TestResource(filePath);
    }

    public static TestResource outputOf(TestOutputCapture testoutput) {
        Objects.requireNonNull(testoutput, "No test output capture provided");
        Path filePath = testoutput.getFilePath();
        return FileHasContent.outputOf(filePath);
    }

    private static Matcher<TestResource> hasSameContentAndTypeAs(TestResource classpathTestResource, String outputFormatValue, boolean validateOutputFormat) {
        if (classpathTestResource == null) {
            Assertions.fail((String)"No classpath resource to match with");
        }
        if (validateOutputFormat && Utility.isBlank((CharSequence)outputFormatValue)) {
            Assertions.fail((String)"No output format provided");
        }
        return new FileHasContent(classpathTestResource, outputFormatValue);
    }

    private FileHasContent(TestResource referenceFileResource, String outputFormatValue) {
        this.referenceFileResource = referenceFileResource;
        this.outputFormatValue = outputFormatValue;
    }

    public void describeMismatch(Object item, Description description) {
        if (this.referenceFileResource == null) {
            String value;
            if (item instanceof TestResource) {
                try {
                    Path fileResource = ((TestResource)item).getFileResource().orElse(null);
                    value = Files.lines(fileResource).limit(5L).collect(Collectors.joining("\n"));
                }
                catch (IOException e) {
                    value = "<some output>";
                }
            } else {
                value = "<some output>";
            }
            description.appendText("was: " + value);
        } else if (this.failures != null) {
            description.appendText("mismatched on:\n" + String.join((CharSequence)"\n", this.failures));
        }
    }

    public void describeTo(Description description) {
        if (this.referenceFileResource == null) {
            description.appendValue((Object)"no output");
        } else {
            description.appendValue((Object)this.referenceFileResource);
        }
    }

    public boolean matches(Object actualValue) {
        try {
            this.failures = null;
            String referenceFile = this.getReferenceFile();
            Path file = this.getFilePath(actualValue);
            if (Utility.isBlank((CharSequence)referenceFile)) {
                return !Files.exists(file, new LinkOption[0]) || Files.size(file) == 0L;
            }
            String outputFormatValue = this.getNonNullOutputFormatValue();
            this.failures = TestUtility.compareOutput(referenceFile, file, outputFormatValue, false);
            return this.failures != null && this.failures.isEmpty();
        }
        catch (Exception e) {
            return (Boolean)Assertions.fail((Throwable)e);
        }
    }

    private Path getFilePath(Object actualValue) {
        if (actualValue == null || !(actualValue instanceof TestResource)) {
            throw new RuntimeException("No file input resource provided");
        }
        Path file = ((TestResource)actualValue).getFileResource().orElseThrow(() -> new RuntimeException("No file input resource provided"));
        return file;
    }

    private String getNonNullOutputFormatValue() {
        String outputFormatValue = Utility.isBlank((CharSequence)this.outputFormatValue) ? "text" : this.outputFormatValue;
        return outputFormatValue;
    }

    private String getReferenceFile() {
        String referenceFile = this.referenceFileResource == null ? null : (String)this.referenceFileResource.getClasspathResource().map(resource -> resource.substring(1)).orElse(null);
        return referenceFile;
    }
}

