/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

final class HeavyDatabaseExtension
implements ExecutionCondition {
    HeavyDatabaseExtension() {
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        boolean overrideForDev;
        boolean bl = overrideForDev = System.getProperty("usetestcontainers") != null;
        if (this.noHeavyDb()) {
            return ConditionEvaluationResult.disabled((String)"Disable heavy database tests since \"heavydb\" is not set");
        }
        if (overrideForDev) {
            return ConditionEvaluationResult.enabled((String)"Override the test of Testcontainers for databases");
        }
        if (OS.LINUX.isCurrentOs()) {
            return ConditionEvaluationResult.enabled((String)"Enable heavy database tests on Linux, since GitHub Actions only supports Docker on this platform");
        }
        return ConditionEvaluationResult.disabled((String)"Disable heavy database tests since conditions are not met");
    }

    private boolean noHeavyDb() {
        String heavydb = System.getProperty("heavydb");
        return heavydb == null || heavydb.toLowerCase().equals("false") || heavydb.toLowerCase().equals("no");
    }
}

