/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.util.function.Function;
import java.util.regex.Pattern;

final class NeuteredExpressionsFilter
implements Function<String, String> {
    private final Pattern[] neuters = new Pattern[]{Pattern.compile("\u001b\\[[;\\d]*m"), Pattern.compile("\u2592"), Pattern.compile("_\\d{5}"), Pattern.compile("SYS_C00\\d{4}"), Pattern.compile("PK__.{8}__[0-9A-F]{16}"), Pattern.compile("main|pool-\\d+-thread-\\d+")};

    NeuteredExpressionsFilter() {
    }

    @Override
    public String apply(String line) {
        String neuteredLine = line;
        for (Pattern neuter : this.neuters) {
            neuteredLine = neuter.matcher(neuteredLine).replaceAll("");
        }
        return neuteredLine;
    }
}

