/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.util.function.Predicate;
import java.util.regex.Pattern;

final class NeuteredLinesFilter
implements Predicate<String> {
    private final Pattern[] neuters = new Pattern[]{Pattern.compile(".*jdbc:.*"), Pattern.compile("database product version.*"), Pattern.compile("driver version.*"), Pattern.compile("-- operating system:.*"), Pattern.compile("-- JVM system:.*"), Pattern.compile("\\s+<schemaCrawler(Version|About|Info)>.*"), Pattern.compile(".*[0-9a-fA-F]{8}-([0-9a-fA-F]{4}-){3}[0-9a-fA-F]{12}.*"), Pattern.compile("\\s+<product(Name|Version)>.*"), Pattern.compile(".*[A-Za-z]+ \\d+, 20[12]\\d \\d+:\\d+ [AP]M.*"), Pattern.compile(".*20[12]\\d-\\d\\d-\\d\\d[ T]\\d\\d:\\d\\d.*"), Pattern.compile("- column @uuid: .*"), Pattern.compile("\\s+\"?run-id\"?\\s?: .*"), Pattern.compile("\\s+\"?crawl-timestamp\"?\\s?: .*"), Pattern.compile("\\s+\"?crawl-timestamp-instant\"?\\s?: .*"), Pattern.compile("\\s*(- )?\"?lint-id\"?\\s?: .*"), Pattern.compile("\\s+\"?linter-instance-id\"?\\s?: .*"), Pattern.compile("\\s+\"?product-version\"?\\s?: .*"), Pattern.compile(".*15\\.0[6-7]\\.\\d\\d.*"), Pattern.compile(".*16\\.\\d{1,2}\\.\\d{1,2}.*"), Pattern.compile(".*(Windows|Linux|Mac OS).*"), Pattern.compile(".*(Java|OpenJDK).*"), Pattern.compile(".*ServerName.*"), Pattern.compile("SQL\\d{15}.*"), Pattern.compile("[\"0-9A-Z]{28,30}.*"), Pattern.compile(".*HOST_NAME.*"), Pattern.compile(".*TOTAL_MEMORY.*"), Pattern.compile(".*TOTAL_CPUS.*"), Pattern.compile(".*OS_NAME.*"), Pattern.compile("SQL\\d+\\s+\\[primary key]"), Pattern.compile("SQL\\d+\\s+\\[foreign key, with no action]"), Pattern.compile("server_uuid\\s+.*"), Pattern.compile("hostname\\s+.*"), Pattern.compile("  value\\s+\\d+\\s+"), Pattern.compile("\\s+value\\s+localhost:\\d+:xe\\s+"), Pattern.compile("\\s+value\\s+localhost:\\d+\\/xepdb1\\s+"), Pattern.compile("BOOKS\\.\\\"ISEQ\\$\\$_\\d+\\\"\\s+\\[sequence\\]"), Pattern.compile(".*pg_temp_.*")};

    NeuteredLinesFilter() {
    }

    @Override
    public boolean test(String line) {
        for (Pattern neuter : this.neuters) {
            if (!neuter.matcher(line).matches()) continue;
            return false;
        }
        return true;
    }
}

