/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class ObjectPropertyTestUtility {
    public static void checkBooleanProperties(Object object, String ... properties) throws Exception {
        for (String property : properties) {
            ObjectPropertyTestUtility.assertBooleanProperty(object, property);
        }
    }

    public static void checkIntegerProperties(Object object, String ... properties) throws Exception {
        for (String property : properties) {
            ObjectPropertyTestUtility.assertIntegerProperty(object, property);
        }
    }

    private static void assertBooleanProperty(Object object, String property) throws Exception {
        for (int i = 0; i < 2; ++i) {
            ObjectPropertyTestUtility.assertBooleanPropertySetting(object, property, true);
            ObjectPropertyTestUtility.assertBooleanPropertySetting(object, property, false);
        }
    }

    private static void assertBooleanPropertySetting(Object object, String property, boolean value) throws Exception {
        ObjectPropertyTestUtility.setProperty(object, property, value);
        MatcherAssert.assertThat((String)String.format("Failed to set %s/%s = %b", object.getClass().getSimpleName(), property, value), (Object)Boolean.valueOf(BeanUtils.getProperty((Object)object, (String)property)), (Matcher)CoreMatchers.is((Object)value));
    }

    private static void assertIntegerProperty(Object object, String property) throws Exception {
        int i = -2;
        while (i < 2) {
            ObjectPropertyTestUtility.assertIntegerPropertySetting(object, property, i);
            i = 3;
        }
        ObjectPropertyTestUtility.assertIntegerPropertySetting(object, property, Integer.MAX_VALUE);
        ObjectPropertyTestUtility.assertIntegerPropertySetting(object, property, Integer.MAX_VALUE);
    }

    private static void assertIntegerPropertySetting(Object object, String property, int value) throws Exception {
        ObjectPropertyTestUtility.setProperty(object, property, value);
        MatcherAssert.assertThat((String)String.format("Failed to set %s/%s = %d", object.getClass().getSimpleName(), property, value), (Object)Integer.valueOf(BeanUtils.getProperty((Object)object, (String)property)), (Matcher)CoreMatchers.is((Object)value));
    }

    private static void setProperty(Object object, String property, boolean value) throws Exception {
        String setterMethodName = "set" + StringUtils.capitalize((String)property);
        MethodUtils.invokeMethod((Object)object, (boolean)true, (String)setterMethodName, (Object[])new Object[]{value});
    }

    private static void setProperty(Object object, String property, int value) throws Exception {
        String setterMethodName = "set" + StringUtils.capitalize((String)property);
        MethodUtils.invokeMethod((Object)object, (boolean)true, (String)setterMethodName, (Object[])new Object[]{value});
    }

    private ObjectPropertyTestUtility() {
    }
}

