/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.ToStringBuilder;

public final class TestContext {
    private final Optional<Class<?>> optionalTestClass;
    private final Optional<Method> optionalTestMethod;

    private static Object nullSafeGet(Optional<?> optional) {
        return optional != null ? optional.orElse(null) : null;
    }

    TestContext(ExtensionContext extensionContext) {
        this.optionalTestClass = extensionContext.getTestClass();
        this.optionalTestMethod = extensionContext.getTestMethod();
    }

    public Path resolveTargetFromRootPath(String relativePath) throws URISyntaxException, IOException {
        Path projectRootPath = this.getProjectRootPath();
        Path directory = projectRootPath.resolve(Paths.get("target", new String[0])).resolve(relativePath).normalize().toAbsolutePath();
        Files.createDirectories(directory, new FileAttribute[0]);
        return directory;
    }

    public String testMethodFullName() {
        return this.optionalTestMethod.map(method -> String.format("%s.%s", method.getDeclaringClass().getSimpleName(), method.getName())).orElseThrow(() -> new RuntimeException("Could not find test method"));
    }

    public String testMethodName() {
        return this.optionalTestMethod.map(Method::getName).orElseThrow(() -> new RuntimeException("Could not find test method"));
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("testClass", TestContext.nullSafeGet(this.optionalTestClass)).append("testMethod", TestContext.nullSafeGet(this.optionalTestMethod)).toString();
    }

    private Path getProjectRootPath() throws URISyntaxException, IOException {
        Class<?> testClass = this.optionalTestClass.orElseThrow(() -> new RuntimeException("Could not find test class"));
        Path codePath = Paths.get(testClass.getProtectionDomain().getCodeSource().getLocation().toURI()).normalize().toAbsolutePath();
        Path projectRoot = codePath.resolve("../..").normalize().toAbsolutePath();
        Files.createDirectories(projectRoot, new FileAttribute[0]);
        return projectRoot;
    }
}

