/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.lang.reflect.Parameter;
import java.sql.Connection;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabase;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseBuilder;
import schemacrawler.test.utility.DatabaseConnectionInfo;
import schemacrawler.test.utility.WithTestDatabase;
import schemacrawler.testdb.TestDatabase;
import us.fatehi.utility.LoggingConfig;
import us.fatehi.utility.Utility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.DatabaseConnectionSources;

final class TestDatabaseConnectionParameterResolver
implements ParameterResolver,
BeforeAllCallback,
AfterAllCallback,
AfterEachCallback {
    private TestDatabase testDatabase;
    private DatabaseConnectionSource dataSource;

    TestDatabaseConnectionParameterResolver() {
    }

    private static boolean isParameterConnection(Parameter parameter) {
        return parameter.getType().isAssignableFrom(Connection.class);
    }

    private static boolean isParameterDatabaseConnectionInfo(Parameter parameter) {
        return parameter.getType().equals(DatabaseConnectionInfo.class);
    }

    private static boolean isParameterDatabaseConnectionSource(Parameter parameter) {
        return parameter.getType().isAssignableFrom(DatabaseConnectionSource.class);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (this.dataSource != null) {
            this.dataSource.close();
            this.dataSource = null;
        }
        this.testDatabase.stop();
    }

    public void afterEach(ExtensionContext context) throws Exception {
        AnnotationType annotationType = this.locateAnnotation(context).getAnnotationType();
        if (annotationType == AnnotationType.methodAnnotation && this.dataSource != null) {
            this.dataSource.close();
            this.dataSource = null;
        }
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        new LoggingConfig();
        this.testDatabase = TestDatabase.initialize();
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        String script = this.locateAnnotation(extensionContext).getScript();
        Parameter parameter = parameterContext.getParameter();
        if (Utility.isBlank((CharSequence)script)) {
            BasicDataSource ds = this.newDataSource();
            this.dataSource = DatabaseConnectionSources.fromDataSource((DataSource)ds);
            if (TestDatabaseConnectionParameterResolver.isParameterConnection(parameter)) {
                return this.dataSource.get();
            }
            if (TestDatabaseConnectionParameterResolver.isParameterDatabaseConnectionInfo(parameter)) {
                return new DatabaseConnectionInfo(this.testDatabase.getHost(), this.testDatabase.getPort(), this.testDatabase.getDatabase(), this.testDatabase.getConnectionUrl());
            }
            if (TestDatabaseConnectionParameterResolver.isParameterDatabaseConnectionSource(parameter)) {
                return this.dataSource;
            }
            throw new ParameterResolutionException("Could not resolve " + parameter);
        }
        EmbeddedDatabase ds = this.newEmbeddedDatabase(script);
        this.dataSource = DatabaseConnectionSources.fromDataSource((DataSource)ds);
        if (TestDatabaseConnectionParameterResolver.isParameterConnection(parameter)) {
            return this.dataSource.get();
        }
        if (TestDatabaseConnectionParameterResolver.isParameterDatabaseConnectionSource(parameter)) {
            return this.dataSource;
        }
        throw new ParameterResolutionException("Could not resolve " + parameter);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        boolean hasConnection = TestDatabaseConnectionParameterResolver.isParameterConnection(parameter);
        boolean hasDatabaseConnectionInfo = TestDatabaseConnectionParameterResolver.isParameterDatabaseConnectionInfo(parameter);
        boolean hasDatabaseConnectionSource = TestDatabaseConnectionParameterResolver.isParameterDatabaseConnectionSource(parameter);
        return hasConnection || hasDatabaseConnectionInfo || hasDatabaseConnectionSource;
    }

    private AnnotationInfo locateAnnotation(ExtensionContext extensionContext) {
        AnnotationType annotationType;
        WithTestDatabase withTestDatabase;
        Optional optionalMethodAnnotation = AnnotationSupport.findAnnotation((Optional)extensionContext.getTestMethod(), WithTestDatabase.class);
        Optional optionalClassAnnotation = AnnotationSupport.findAnnotation((Optional)extensionContext.getTestClass(), WithTestDatabase.class);
        if (optionalMethodAnnotation.isPresent()) {
            withTestDatabase = (WithTestDatabase)optionalMethodAnnotation.get();
            annotationType = AnnotationType.methodAnnotation;
        } else if (optionalClassAnnotation.isPresent()) {
            withTestDatabase = (WithTestDatabase)optionalClassAnnotation.get();
            annotationType = AnnotationType.classAnnotation;
        } else {
            withTestDatabase = null;
            annotationType = AnnotationType.classAnnotation;
        }
        String script = withTestDatabase != null ? withTestDatabase.script() : null;
        return new AnnotationInfo(script, annotationType);
    }

    private BasicDataSource newDataSource() {
        BasicDataSource ds = new BasicDataSource();
        ds.setUrl(this.testDatabase.getConnectionUrl());
        ds.setUsername("sa");
        ds.setPassword("");
        return ds;
    }

    private EmbeddedDatabase newEmbeddedDatabase(String script) {
        EmbeddedDatabase db = new EmbeddedDatabaseBuilder().generateUniqueName(true).setScriptEncoding("UTF-8").ignoreFailedDrops(true).addScript(script).build();
        return db;
    }

    private static class AnnotationInfo {
        private final String script;
        private final AnnotationType annotationType;

        public AnnotationInfo(String script, AnnotationType annotationType) {
            this.script = script;
            this.annotationType = annotationType;
        }

        public AnnotationType getAnnotationType() {
            return this.annotationType;
        }

        public String getScript() {
            return this.script;
        }
    }

    private static enum AnnotationType {
        classAnnotation,
        methodAnnotation;

    }
}

