/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import schemacrawler.test.utility.TestOutputCapture;
import us.fatehi.utility.IOUtility;

public final class TestOutputStream
extends OutputStream
implements TestOutputCapture {
    private final Path tempFile;
    private final OutputStream out;

    public TestOutputStream() {
        try {
            this.tempFile = IOUtility.createTempFilePath((String)"test", (String)"");
            this.out = Files.newOutputStream(this.tempFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open output stream to a temporary file", e);
        }
    }

    @Override
    public String getContents() {
        try {
            this.out.flush();
            this.out.close();
            return new String(Files.readAllBytes(this.tempFile), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path getFilePath() {
        return this.tempFile;
    }

    public String toString() {
        return this.tempFile.toString();
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }
}

