/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;

final class TestResource {
    private final Path path;
    private final String resource;

    public TestResource() {
        this.path = null;
        this.resource = null;
    }

    TestResource(Path path) {
        Objects.requireNonNull(path, "No path provided");
        this.path = path;
        this.resource = null;
    }

    TestResource(String resource) {
        Objects.requireNonNull(resource, "No resource provided");
        this.path = null;
        this.resource = resource;
    }

    public Optional<String> getClasspathResource() {
        return Optional.ofNullable(this.resource);
    }

    public Optional<Path> getFileResource() {
        return Optional.ofNullable(this.path);
    }

    public String toString() {
        if (this.path != null) {
            return String.format("file: <%s>", this.path);
        }
        if (this.resource != null) {
            return String.format("classpath: <%s>", this.resource);
        }
        return "<empty>";
    }
}

