/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.condition.JRE;
import org.opentest4j.TestAbortedException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.MetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.test.utility.DatabaseTestUtility;
import schemacrawler.test.utility.NeuteredExpressionsFilter;
import schemacrawler.test.utility.NeuteredLinesFilter;
import schemacrawler.test.utility.SvgElementFilter;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.ioresource.InputResource;

public final class TestUtility {
    public static void clean(String dirname) throws Exception {
        FileUtils.deleteDirectory((File)TestUtility.buildDirectory().resolve("unit_tests_results_output").resolve(dirname).toFile());
    }

    public static List<String> compareCompressedOutput(String referenceFile, Path testOutputTempFile, String outputFormat) throws Exception {
        return TestUtility.compareOutput(referenceFile, testOutputTempFile, outputFormat, true);
    }

    public static List<String> compareOutput(String referenceFile, Path testOutputTempFile, String outputFormat) throws Exception {
        return TestUtility.compareOutput(referenceFile, testOutputTempFile, outputFormat, false);
    }

    public static List<String> compareOutput(String referenceFile, Path testOutputTempFile, String outputFormat, boolean isCompressed) throws Exception {
        boolean contentEquals;
        Objects.requireNonNull(referenceFile, "Reference file is not defined");
        Objects.requireNonNull(testOutputTempFile, "Output file is not defined");
        Objects.requireNonNull(outputFormat, "Output format is not defined");
        if (!IOUtility.isFileReadable((Path)testOutputTempFile)) {
            return Collections.singletonList("Output file not created - " + testOutputTempFile);
        }
        ArrayList<String> failures = new ArrayList<String>();
        Reader referenceReader = TestUtility.readerForResource(referenceFile, StandardCharsets.UTF_8, isCompressed);
        if (referenceReader == null) {
            failures.add("Reference file not available, " + referenceFile);
            contentEquals = false;
        } else if ("png".equals(outputFormat)) {
            contentEquals = true;
        } else {
            Reader fileReader = TestUtility.readerForFile(testOutputTempFile, isCompressed);
            Predicate<String> linesFilter = new SvgElementFilter().and(new NeuteredLinesFilter());
            NeuteredExpressionsFilter neuterMap = new NeuteredExpressionsFilter();
            contentEquals = TestUtility.contentEquals(referenceReader, fileReader, failures, linesFilter, neuterMap);
        }
        if ("html".equals(outputFormat)) {
            TestUtility.validateXML(testOutputTempFile, failures);
        }
        if ("htmlx".equals(outputFormat)) {
            TestUtility.validateXML(testOutputTempFile, failures);
        } else if ("png".equals(outputFormat)) {
            TestUtility.validateDiagram(testOutputTempFile);
        }
        if (!contentEquals) {
            System.setOut(new PrintStream(new FileOutputStream(FileDescriptor.out)));
            System.setErr(new PrintStream(new FileOutputStream(FileDescriptor.err)));
            Path testOutputTargetFilePath = TestUtility.buildDirectory().resolve("unit_tests_results_output").resolve(referenceFile);
            Files.createDirectories(testOutputTargetFilePath.getParent(), new FileAttribute[0]);
            TestUtility.deleteIfPossible(testOutputTargetFilePath);
            Files.move(testOutputTempFile, testOutputTargetFilePath, StandardCopyOption.REPLACE_EXISTING);
            System.err.printf("%nOutput does not match - actual output in%n%s%n", testOutputTargetFilePath);
        } else {
            Files.delete(testOutputTempFile);
        }
        return failures;
    }

    public static Path copyResourceToTempFile(String resource) throws IOException {
        if (Utility.isBlank((CharSequence)resource)) {
            throw new IOException("Cannot read empty resource");
        }
        try (InputStream resourceStream = TestUtility.class.getResourceAsStream(resource);){
            Objects.requireNonNull(resourceStream, "Resource not found, " + resource);
            Path path = TestUtility.writeToTempFile(resourceStream);
            return path;
        }
    }

    public static void deleteIfPossible(Path testOutputTargetFilePath) {
        try {
            Files.deleteIfExists(testOutputTargetFilePath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static <V> V failTestSetup(String message) {
        TestUtility.testAborted(message, null);
        return null;
    }

    public static <V> V failTestSetup(String message, Exception e) {
        TestUtility.testAborted(message, e);
        return null;
    }

    /*
     * Exception decompiling
     */
    public static String fileHeaderOf(Path tempFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String[] flattenCommandlineArgs(Map<String, String> argsMap) {
        ArrayList<String> argsList = new ArrayList<String>();
        for (Map.Entry<String, String> arg : argsMap.entrySet()) {
            String key = arg.getKey();
            String value = arg.getValue();
            if (value != null) {
                argsList.add(String.format("%s=%s", key, value));
                continue;
            }
            argsList.add(String.format("%s", key));
        }
        String[] args = argsList.toArray(new String[0]);
        return args;
    }

    public static String javaVersion() {
        if (JRE.currentVersion() == JRE.JAVA_8) {
            return "8";
        }
        return "LTE";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties loadProperties(InputResource inputResource) {
        Objects.requireNonNull(inputResource, "No input resource provided");
        try (Reader reader = inputResource.openNewInputReader(StandardCharsets.UTF_8);){
            Properties properties2 = new Properties();
            properties2.load(reader);
            Properties properties = properties2;
            return properties;
        }
        catch (IOException e) {
            return new Properties();
        }
    }

    public static SchemaRetrievalOptions newSchemaRetrievalOptions() throws IOException {
        Map<String, String> config = DatabaseTestUtility.loadHsqldbConfig();
        InformationSchemaViewsBuilder builder = InformationSchemaViewsBuilder.builder();
        for (InformationSchemaKey informationSchemaKey : InformationSchemaKey.values()) {
            String lookupKey = String.format("select.%s.%s", informationSchemaKey.getType(), informationSchemaKey);
            if (!config.containsKey(lookupKey)) continue;
            try {
                builder.withSql(informationSchemaKey, config.get(lookupKey));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        InformationSchemaViews informationSchemaViews = builder.toOptions();
        return SchemaRetrievalOptionsBuilder.builder().withInformationSchemaViews(informationSchemaViews).with(SchemaInfoMetadataRetrievalStrategy.tableColumnPrivilegesRetrievalStrategy, MetadataRetrievalStrategy.data_dictionary_all).toOptions();
    }

    public static Reader readerForResource(String resource, Charset encoding) throws IOException {
        return TestUtility.readerForResource(resource, encoding, false);
    }

    public static Path savePropertiesToTempFile(Properties properties) throws IOException {
        Objects.requireNonNull(properties, "No properties provided");
        Path propertiesFile = Files.createTempFile("schemacrawler", ".properties", new FileAttribute[0]);
        BufferedWriter writer = Files.newBufferedWriter(propertiesFile, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        properties.store(writer, "Temporary file to hold properties");
        return propertiesFile;
    }

    public static void validateDiagram(Path diagramFile) throws IOException {
        MatcherAssert.assertThat((String)"Diagram file not created", (Object)Files.exists(diagramFile, new LinkOption[0]), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"Diagram file has 0 bytes size", (Object)Files.size(diagramFile), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }

    public static Path writeStringToTempFile(String data) throws IOException {
        Path tempFile = IOUtility.createTempFilePath((String)"resource", (String)"data").normalize().toAbsolutePath();
        if (data == null) {
            return tempFile;
        }
        NeuteredExpressionsFilter neuteredExpressionsFilter = new NeuteredExpressionsFilter();
        String filteredData = neuteredExpressionsFilter.apply(data);
        Files.write(tempFile, filteredData.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return tempFile;
    }

    private static Path buildDirectory() throws Exception {
        StackTraceElement ste = TestUtility.currentMethodStackTraceElement();
        Class<?> callingClass = Class.forName(ste.getClassName());
        Path codePath = Paths.get(callingClass.getProtectionDomain().getCodeSource().getLocation().toURI()).normalize().toAbsolutePath();
        boolean isInTarget = codePath.toString().contains("target");
        if (!isInTarget) {
            throw new RuntimeException("Not in build directory, " + codePath);
        }
        Path directory = codePath.resolve("..");
        return directory.normalize().toAbsolutePath();
    }

    /*
     * Exception decompiling
     */
    private static boolean contentEquals(Reader expectedInputReader, Reader actualInputReader, List<String> failures, Predicate<String> keepLines, Function<String, String> neuterMap) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 45[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static StackTraceElement currentMethodStackTraceElement() {
        StackTraceElement[] stackTrace;
        Pattern baseTestClassName = Pattern.compile(".*\\.Base.*Test");
        Pattern testClassName = Pattern.compile(".*\\.[A-Z].*Test");
        for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
            String className = stackTraceElement.getClassName();
            if (!testClassName.matcher(className).matches() || baseTestClassName.matcher(className).matches()) continue;
            return stackTraceElement;
        }
        return null;
    }

    private static void fastChannelCopy(ReadableByteChannel src, WritableByteChannel dest) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }

    private static String lineMiscompare(String expectedline, String actualLine) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(">> expected followed by actual:").append("\n");
        buffer.append(expectedline).append("\n");
        buffer.append(actualLine).append("\n");
        String lineMiscompare = buffer.toString();
        return lineMiscompare;
    }

    private static Reader openNewCompressedInputReader(InputStream inputStream, Charset charset) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        zipInputStream.getNextEntry();
        return new InputStreamReader((InputStream)zipInputStream, charset);
    }

    private static Reader readerForFile(Path testOutputTempFile) throws IOException {
        return TestUtility.readerForFile(testOutputTempFile, false);
    }

    private static Reader readerForFile(Path testOutputTempFile, boolean isCompressed) throws IOException {
        BufferedReader bufferedReader;
        if (isCompressed) {
            ZipInputStream inputStream = new ZipInputStream(Files.newInputStream(testOutputTempFile, StandardOpenOption.READ));
            inputStream.getNextEntry();
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
        } else {
            bufferedReader = Files.newBufferedReader(testOutputTempFile, StandardCharsets.UTF_8);
        }
        return bufferedReader;
    }

    private static Reader readerForResource(String resource, Charset encoding, boolean isCompressed) throws IOException {
        Reader reader;
        InputStream inputStream = TestUtility.class.getResourceAsStream("/" + resource);
        if (inputStream != null) {
            Charset charset = encoding == null ? StandardCharsets.UTF_8 : encoding;
            reader = isCompressed ? TestUtility.openNewCompressedInputReader(inputStream, charset) : new InputStreamReader(inputStream, charset);
        } else {
            reader = null;
        }
        return reader;
    }

    private static void testAborted(String message, Exception e) {
        throw new TestAbortedException(message, (Throwable)e);
    }

    private static void validateXML(Path testOutputFile, final List<String> failures) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException e) throws SAXException {
                failures.add(e.getMessage());
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                failures.add(e.getMessage());
            }

            @Override
            public void warning(SAXParseException e) throws SAXException {
                failures.add(e.getMessage());
            }
        });
        builder.parse(new InputSource(TestUtility.readerForFile(testOutputFile)));
    }

    private static Path writeToTempFile(InputStream resourceStream) throws IOException {
        Path tempFile = IOUtility.createTempFilePath((String)"resource", (String)"data").normalize().toAbsolutePath();
        try (OutputStream tempFileStream = Files.newOutputStream(tempFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            TestUtility.fastChannelCopy(Channels.newChannel(resourceStream), Channels.newChannel(tempFileStream));
        }
        return tempFile;
    }

    private TestUtility() {
    }
}

