/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import schemacrawler.test.utility.TestOutputCapture;
import schemacrawler.test.utility.TestOutputStream;

public final class TestWriter
extends Writer
implements TestOutputCapture {
    private static final String lineSeparator = System.getProperty("line.separator");
    private final TestOutputStream out = new TestOutputStream();

    @Override
    public void close() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not close test writer", e);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public String getContents() {
        return this.out.getContents();
    }

    @Override
    public Path getFilePath() {
        return this.out.getFilePath();
    }

    public void println() {
        this.writeout(lineSeparator);
    }

    public void println(Object x) {
        this.println(Objects.toString(x));
    }

    public void println(String x) {
        this.writeout(x);
        this.println();
    }

    public String toString() {
        return this.out.toString();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writeout(new String(cbuf, off, len));
    }

    private void writeout(String x) {
        try {
            this.out.write(Objects.toString(x).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

