/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.test.utility;

import java.util.AbstractMap;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import schemacrawler.test.utility.WithSystemProperty;
import us.fatehi.utility.Utility;

final class WithSystemPropertyExtension
implements BeforeEachCallback,
AfterEachCallback {
    private AbstractMap.SimpleImmutableEntry<String, String> systemProperty;

    WithSystemPropertyExtension() {
    }

    public void afterEach(ExtensionContext context) throws Exception {
        System.clearProperty(this.systemProperty.getKey());
        this.systemProperty = null;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Optional optionalAnnotation = AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), WithSystemProperty.class);
        optionalAnnotation.ifPresent(withSystemProperty -> {
            String key = withSystemProperty.key();
            if (Utility.isBlank((CharSequence)key)) {
                throw new IllegalArgumentException("No system property name provided");
            }
            this.systemProperty = new AbstractMap.SimpleImmutableEntry<String, String>(key, withSystemProperty.value());
            System.setProperty(this.systemProperty.getKey(), this.systemProperty.getValue());
        });
    }
}

