SELECT
  COLUMNS.TABLE_CAT,
  COLUMNS.TABLE_SCHEM,
  COLUMNS.TABLE_NAME,
  COLUMNS.COLUMN_NAME,
  CASE WHEN COLUMNS2.UDT_NAME IS NOT NULL THEN UDTS.DATA_TYPE ELSE COLUMNS.DATA_TYPE END AS DATA_TYPE,
  COALESCE(COLUMNS2.UDT_NAME, COLUMNS.TYPE_NAME) AS TYPE_NAME,
  COLUMNS.COLUMN_SIZE,
  COLUMNS.BUFFER_LENGTH,
  COLUMNS.DECIMAL_DIGITS,
  COLUMNS.NUM_PREC_RADIX,
  COLUMNS.NULLABLE,
  COLUMNS.REMARKS,
  COLUMNS.COLUMN_DEF,
  COLUMNS.SQL_DATA_TYPE,
  COLUMNS.SQL_DATETIME_SUB,
  COLUMNS.CHAR_OCTET_LENGTH,
  COLUMNS.ORDINAL_POSITION,
  COLUMNS.IS_NULLABLE,
  COLUMNS.SCOPE_CATALOG,
  COLUMNS.SCOPE_SCHEMA,
  COLUMNS.SCOPE_TABLE,
  COLUMNS.SOURCE_DATA_TYPE,
  COLUMNS.IS_AUTOINCREMENT,
  COLUMNS.IS_GENERATEDCOLUMN,
  CASE WHEN COLUMNS.IS_GENERATEDCOLUMN = 'NO' THEN 'NEVER' ELSE '' END AS IS_GENERATED,
  NULL AS GENERATION_EXPRESSION
FROM
  INFORMATION_SCHEMA.SYSTEM_COLUMNS AS COLUMNS
  INNER JOIN INFORMATION_SCHEMA.COLUMNS AS COLUMNS2 ON
    COLUMNS.TABLE_CAT = COLUMNS2.TABLE_CATALOG
    AND COLUMNS.TABLE_SCHEM = COLUMNS2.TABLE_SCHEMA
    AND COLUMNS.TABLE_NAME = COLUMNS2.TABLE_NAME
    AND COLUMNS.COLUMN_NAME = COLUMNS2.COLUMN_NAME
  LEFT OUTER JOIN INFORMATION_SCHEMA.SYSTEM_UDTS AS UDTS ON
    COLUMNS.TABLE_CAT = UDTS.TYPE_CAT
    AND COLUMNS.TABLE_SCHEM = UDTS.TYPE_SCHEM
    AND COLUMNS2.UDT_NAME = UDTS.TYPE_NAME
