/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import schemacrawler.schema.AttributedObject;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.ReducibleCollection;
import us.fatehi.utility.ObjectToString;

final class NamedObjectList<N extends NamedObject>
implements Serializable,
ReducibleCollection<N> {
    private static final long serialVersionUID = 3257847666804142128L;
    private static final String SCHEMACRAWLER_FILTERED_OUT = "schemacrawler.filtered_out";
    private final Map<NamedObjectKey, N> objects = new ConcurrentHashMap<NamedObjectKey, N>();
    private final Map<NamedObjectKey, N> filteredObjects = new ConcurrentHashMap<NamedObjectKey, N>();

    NamedObjectList() {
    }

    private static NamedObjectKey makeLookupKey(NamedObject namedObject) {
        NamedObjectKey key = namedObject == null ? null : namedObject.key();
        return key;
    }

    private static NamedObjectKey makeLookupKey(NamedObject namedObject, String name) {
        NamedObjectKey key = NamedObjectList.makeLookupKey(namedObject);
        if (key != null) {
            key = key.with(name);
        }
        return key;
    }

    @Override
    public synchronized void filter(Predicate<? super N> predicate) {
        if (predicate == null) {
            return;
        }
        Set<Map.Entry<NamedObjectKey, N>> entrySet = this.objects.entrySet();
        Iterator<Map.Entry<NamedObjectKey, N>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<NamedObjectKey, N> entry = iterator.next();
            NamedObjectKey namedObjectKey = entry.getKey();
            NamedObject namedObject = (NamedObject)entry.getValue();
            if (predicate.test(namedObject)) continue;
            iterator.remove();
            this.filteredObjects.put(namedObjectKey, namedObject);
            if (!(namedObject instanceof AttributedObject)) continue;
            AttributedObject attributedObject = (AttributedObject)((Object)namedObject);
            attributedObject.setAttribute(SCHEMACRAWLER_FILTERED_OUT, true);
        }
    }

    @Override
    public Iterator<N> iterator() {
        final class UnmodifiableIterator
        implements Iterator<N> {
            private final Iterator<N> iterator;

            UnmodifiableIterator(Iterator<N> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public N next() {
                return (NamedObject)this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
        return new UnmodifiableIterator(this.values().iterator());
    }

    @Override
    public synchronized void resetFilter() {
        Set<Map.Entry<NamedObjectKey, N>> entrySet = this.filteredObjects.entrySet();
        Iterator<Map.Entry<NamedObjectKey, N>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<NamedObjectKey, N> entry = iterator.next();
            NamedObjectKey namedObjectKey = entry.getKey();
            NamedObject namedObject = (NamedObject)entry.getValue();
            this.objects.put(namedObjectKey, namedObject);
            iterator.remove();
            if (!(namedObject instanceof AttributedObject)) continue;
            AttributedObject attributedObject = (AttributedObject)((Object)namedObject);
            attributedObject.removeAttribute(SCHEMACRAWLER_FILTERED_OUT);
        }
    }

    public String toString() {
        return ObjectToString.toString(this.values());
    }

    boolean add(N namedObject) {
        Objects.requireNonNull(namedObject, "Cannot add a null object to the list");
        NamedObjectKey key = NamedObjectList.makeLookupKey(namedObject);
        this.objects.put(key, namedObject);
        return true;
    }

    boolean contains(NamedObject namedObject) {
        return this.objects.containsKey(NamedObjectList.makeLookupKey(namedObject));
    }

    boolean isEmpty() {
        return this.objects.isEmpty();
    }

    Optional<N> lookup(NamedObject namedObject, String name) {
        NamedObjectKey key = NamedObjectList.makeLookupKey(namedObject, name);
        return this.internalGet(key);
    }

    Optional<N> lookup(NamedObjectKey lookupKey) {
        return this.internalGet(lookupKey);
    }

    N remove(N namedObject) {
        return (N)((NamedObject)this.objects.remove(NamedObjectList.makeLookupKey(namedObject)));
    }

    int size() {
        return this.objects.size();
    }

    List<N> values() {
        ArrayList<N> all = new ArrayList<N>(this.objects.values());
        all.sort(Comparator.naturalOrder());
        return all;
    }

    private Optional<N> internalGet(NamedObjectKey key) {
        return Optional.ofNullable(this.objects.get(key));
    }
}

