/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.InclusionRuleWithRegularExpression;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.Query;
import schemacrawler.utility.MetaDataUtility;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.TemplatingUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.string.StringFormat;

public final class QueryUtility {
    private static final Logger LOGGER = Logger.getLogger(QueryUtility.class.getName());

    public static ResultSet executeAgainstColumnDataType(Query query, Statement statement, ColumnDataType columnDataType) throws SQLException {
        Objects.requireNonNull(query, "No query provided");
        Map<String, String> variablesMap = QueryUtility.makeVariablesMap(columnDataType);
        String sql = QueryUtility.expandQuery(query, variablesMap);
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Executing %s: %n%s", new Object[]{query.getName(), sql}));
        return DatabaseUtility.executeSql((Statement)statement, (String)sql);
    }

    public static ResultSet executeAgainstSchema(Query query, Statement statement, Map<String, InclusionRule> limitMap) throws SQLException {
        Objects.requireNonNull(query, "No query provided");
        Map<String, String> variablesMap = QueryUtility.makeVariablesMap(limitMap);
        String sql = QueryUtility.expandQuery(query, variablesMap);
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Executing %s: %n%s", new Object[]{query.getName(), sql}));
        return DatabaseUtility.executeSql((Statement)statement, (String)sql);
    }

    public static ResultSet executeAgainstTable(Query query, Statement statement, Table table, boolean isAlphabeticalSortForTableColumns, Identifiers identifiers) throws SQLException {
        Objects.requireNonNull(query, "No query provided");
        Map<String, String> variablesMap = QueryUtility.makeVariablesMap(table, isAlphabeticalSortForTableColumns, identifiers);
        String sql = QueryUtility.expandQuery(query, variablesMap);
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Executing %s: %n%s", new Object[]{query.getName(), sql}));
        return DatabaseUtility.executeSql((Statement)statement, (String)sql);
    }

    public static long executeForLong(Query query, Connection connection, Table table, Identifiers identifiers) throws SQLException {
        Objects.requireNonNull(query, "No query provided");
        Map<String, String> variablesMap = QueryUtility.makeVariablesMap(table, true, identifiers);
        String sql = QueryUtility.expandQuery(query, variablesMap);
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Executing %s: %n%s", new Object[]{query.getName(), sql}));
        return DatabaseUtility.executeSqlForLong((Connection)connection, (String)sql);
    }

    public static Object executeForScalar(Query query, Connection connection) throws SQLException {
        Objects.requireNonNull(query, "No query provided");
        String sql = QueryUtility.expandQuery(query);
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Executing %s: %n%s", new Object[]{query.getName(), sql}));
        return DatabaseUtility.executeSqlForScalar((Connection)connection, (String)sql);
    }

    public static Object executeForScalar(Query query, Connection connection, Table table, Identifiers identifiers) throws SQLException {
        Objects.requireNonNull(query, "No query provided");
        Map<String, String> variablesMap = QueryUtility.makeVariablesMap(table, true, identifiers);
        String sql = QueryUtility.expandQuery(query, variablesMap);
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Executing %s: %n%s", new Object[]{query.getName(), sql}));
        return DatabaseUtility.executeSqlForScalar((Connection)connection, (String)sql);
    }

    public static Query getQueryFromResource(String name, String resource) {
        String sql = IOUtility.readResourceFully((String)resource);
        return new Query(name, sql);
    }

    protected static void addInclusionRule(String limitType, InclusionRule schemaInclusionRule, Map<String, String> properties) {
        String schemaInclusionPattern;
        properties.put(limitType, ".*");
        if (schemaInclusionRule instanceof InclusionRuleWithRegularExpression && !Utility.isBlank((CharSequence)(schemaInclusionPattern = ((InclusionRuleWithRegularExpression)schemaInclusionRule).getInclusionPattern().pattern()))) {
            properties.put(limitType, schemaInclusionPattern);
        }
    }

    private static String expandQuery(Query query) {
        return QueryUtility.expandQuery(query, null);
    }

    private static String expandQuery(Query query, Map<String, String> variablesMap) {
        String sql = query.getQuery();
        if (variablesMap != null && !variablesMap.isEmpty()) {
            sql = TemplatingUtility.expandTemplate((String)sql, variablesMap);
        }
        return TemplatingUtility.expandTemplate((String)sql);
    }

    private static Map<String, String> makeVariablesMap(ColumnDataType columnDataType) {
        Objects.requireNonNull(columnDataType, "No column data type provided");
        HashMap<String, String> variablesMap = new HashMap<String, String>();
        variablesMap.put("column-data-type", columnDataType.getName());
        return variablesMap;
    }

    private static Map<String, String> makeVariablesMap(Map<String, InclusionRule> limitMap) {
        Objects.requireNonNull(limitMap, "No limit map provided");
        HashMap<String, String> variablesMap = new HashMap<String, String>();
        for (Map.Entry<String, InclusionRule> limit : limitMap.entrySet()) {
            QueryUtility.addInclusionRule(limit.getKey(), limit.getValue(), variablesMap);
        }
        return variablesMap;
    }

    private static Map<String, String> makeVariablesMap(Table table, boolean isAlphabeticalSortForTableColumns, Identifiers identifiers) {
        Objects.requireNonNull(identifiers, "No identifiers provided");
        HashMap<String, String> tableProperties = new HashMap<String, String>();
        if (table != null) {
            NamedObjectSort columnsSort = NamedObjectSort.getNamedObjectSort(isAlphabeticalSortForTableColumns);
            List<Column> columns = table.getColumns();
            columns.sort(columnsSort);
            Schema schema = table.getSchema();
            if (schema != null) {
                String schemaName = identifiers.quoteFullName(schema);
                tableProperties.put("schema", schemaName);
            }
            tableProperties.put("table", identifiers.quoteFullName(table));
            tableProperties.put("tablename", table.getName());
            tableProperties.put("columns", MetaDataUtility.joinColumns(columns, false, identifiers));
            tableProperties.put("orderbycolumns", MetaDataUtility.joinColumns(columns, true, identifiers));
            tableProperties.put("tabletype", table.getTableType().toString());
        }
        return tableProperties;
    }

    private QueryUtility() {
    }
}

