/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class TypeMap
implements Map<String, Class<?>> {
    private static final Logger LOGGER = Logger.getLogger(TypeMap.class.getName());
    private final Map<String, Class<?>> sqlTypeMap;

    private static Map<SQLType, Class<?>> createDefaultTypeMap() {
        HashMap defaultTypeMap = new HashMap();
        defaultTypeMap.put(JDBCType.ARRAY, Array.class);
        defaultTypeMap.put(JDBCType.BIGINT, Long.class);
        defaultTypeMap.put(JDBCType.BINARY, byte[].class);
        defaultTypeMap.put(JDBCType.BIT, Boolean.class);
        defaultTypeMap.put(JDBCType.BLOB, Blob.class);
        defaultTypeMap.put(JDBCType.BOOLEAN, Boolean.class);
        defaultTypeMap.put(JDBCType.CHAR, String.class);
        defaultTypeMap.put(JDBCType.CLOB, Clob.class);
        defaultTypeMap.put(JDBCType.DATALINK, URL.class);
        defaultTypeMap.put(JDBCType.DATE, Date.class);
        defaultTypeMap.put(JDBCType.DECIMAL, BigDecimal.class);
        defaultTypeMap.put(JDBCType.DISTINCT, Object.class);
        defaultTypeMap.put(JDBCType.DOUBLE, Double.class);
        defaultTypeMap.put(JDBCType.FLOAT, Double.class);
        defaultTypeMap.put(JDBCType.INTEGER, Integer.class);
        defaultTypeMap.put(JDBCType.JAVA_OBJECT, Object.class);
        defaultTypeMap.put(JDBCType.LONGNVARCHAR, String.class);
        defaultTypeMap.put(JDBCType.LONGVARBINARY, byte[].class);
        defaultTypeMap.put(JDBCType.LONGVARCHAR, String.class);
        defaultTypeMap.put(JDBCType.NCHAR, String.class);
        defaultTypeMap.put(JDBCType.NCLOB, NClob.class);
        defaultTypeMap.put(JDBCType.NULL, Void.class);
        defaultTypeMap.put(JDBCType.NUMERIC, BigDecimal.class);
        defaultTypeMap.put(JDBCType.NVARCHAR, String.class);
        defaultTypeMap.put(JDBCType.OTHER, Object.class);
        defaultTypeMap.put(JDBCType.REAL, Float.class);
        defaultTypeMap.put(JDBCType.REF, Ref.class);
        defaultTypeMap.put(JDBCType.REF_CURSOR, Object.class);
        defaultTypeMap.put(JDBCType.ROWID, RowId.class);
        defaultTypeMap.put(JDBCType.SMALLINT, Integer.class);
        defaultTypeMap.put(JDBCType.SQLXML, SQLXML.class);
        defaultTypeMap.put(JDBCType.STRUCT, Struct.class);
        defaultTypeMap.put(JDBCType.TIME, Time.class);
        defaultTypeMap.put(JDBCType.TIMESTAMP, Timestamp.class);
        defaultTypeMap.put(JDBCType.TIMESTAMP_WITH_TIMEZONE, OffsetDateTime.class);
        defaultTypeMap.put(JDBCType.TIME_WITH_TIMEZONE, OffsetTime.class);
        defaultTypeMap.put(JDBCType.TINYINT, Integer.class);
        defaultTypeMap.put(JDBCType.VARBINARY, byte[].class);
        defaultTypeMap.put(JDBCType.VARCHAR, String.class);
        return defaultTypeMap;
    }

    public TypeMap() {
        this.sqlTypeMap = new HashMap();
        Map<SQLType, Class<?>> defaultTypeMap = TypeMap.createDefaultTypeMap();
        for (Map.Entry<SQLType, Class<?>> sqlTypeMapping : defaultTypeMap.entrySet()) {
            this.sqlTypeMap.put(sqlTypeMapping.getKey().getName(), sqlTypeMapping.getValue());
        }
    }

    public TypeMap(Connection connection) {
        this();
        if (connection == null) {
            LOGGER.log(Level.WARNING, "No connection provided, so not getting connection specific type map");
            return;
        }
        try {
            Map<String, Class<?>> typeMap = connection.getTypeMap();
            if (typeMap != null && !typeMap.isEmpty()) {
                this.sqlTypeMap.putAll(typeMap);
            } else {
                LOGGER.log(Level.CONFIG, "No type map available from database connection");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not obtain data type map from connection", e);
        }
    }

    public TypeMap(Map<String, Class<?>> sqlTypeMap) {
        this.sqlTypeMap = sqlTypeMap == null ? new HashMap() : new HashMap(sqlTypeMap);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.sqlTypeMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.sqlTypeMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Class<?>>> entrySet() {
        return new HashMap(this.sqlTypeMap).entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.sqlTypeMap.equals(o);
    }

    @Override
    public Class<?> get(Object key) {
        if (this.containsKey(key)) {
            return this.sqlTypeMap.get(key);
        }
        return Object.class;
    }

    @Override
    public int hashCode() {
        return this.sqlTypeMap.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.sqlTypeMap.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return new HashSet<String>(this.sqlTypeMap.keySet());
    }

    @Override
    public Class<?> put(String key, Class<?> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Class<?>> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?> remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.sqlTypeMap.size();
    }

    public String toString() {
        Map<String, String> typeClassNameMap = this.sqlTypeMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Class)e.getValue()).getCanonicalName()));
        return typeClassNameMap.toString();
    }

    @Override
    public Collection<Class<?>> values() {
        return new HashSet(this.sqlTypeMap.values());
    }
}

