/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.command;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import picocli.CommandLine;
import schemacrawler.Version;
import schemacrawler.tools.commandline.SchemaCrawlerShellCommands;
import schemacrawler.tools.commandline.command.AvailableCatalogLoaders;
import schemacrawler.tools.commandline.command.AvailableCommands;
import schemacrawler.tools.commandline.state.ShellState;
import schemacrawler.tools.commandline.state.StateFactory;
import schemacrawler.tools.commandline.utility.CommandLineUtility;
import schemacrawler.tools.executable.commandline.PluginCommandType;
import us.fatehi.utility.Utility;

@CommandLine.Command(name="help", header={"Display SchemaCrawler command-line help"}, helpCommand=true, headerHeading="", synopsisHeading="Shell Command:%n", customSynopsis={"help"}, optionListHeading="Options:%n")
public final class CommandLineHelpCommand
implements Runnable {
    @CommandLine.Parameters(index="0", arity="0..1")
    private String command;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Displays SchemaCrawler command-line help"})
    private boolean helpRequested;

    public boolean isHelpRequested() {
        return this.helpRequested;
    }

    @Override
    public void run() {
        ShellState state = new ShellState();
        CommandLine parent = CommandLineUtility.newCommandLine(new SchemaCrawlerShellCommands(), new StateFactory(state));
        CommandLineUtility.addPluginHelpCommands(parent, CommandLineUtility.catalogLoaderPluginHelpCommands);
        CommandLineUtility.addPluginHelpCommands(parent, CommandLineUtility.commandPluginHelpCommands);
        CommandLineUtility.addPluginHelpCommands(parent, CommandLineUtility.serverPluginHelpCommands);
        if (!Utility.isBlank((CharSequence)this.command)) {
            this.configureHelpForSubcommand(parent);
            this.showHelpForSubcommand(parent, this.command);
        } else {
            this.showCompleteHelp(parent);
        }
    }

    private void configureHelpForSubcommand(CommandLine commandLine) {
        if (commandLine == null) {
            return;
        }
        commandLine.setHelpSectionKeys(Arrays.asList("header", "description", "parameterList", "optionList", "commandList", "footer"));
    }

    private Optional<CommandLine> lookupCommand(CommandLine parent, String command) {
        return Optional.ofNullable(parent.getSubcommands().get(command));
    }

    private void showCompleteHelp(CommandLine parent) {
        System.out.println(Version.about());
        System.out.printf("%n%n", new Object[0]);
        Stream[] streamArray = new Stream[5];
        streamArray[0] = Stream.of("log", "config-file", "connect", "limit", "grep", "filter");
        streamArray[1] = StreamSupport.stream(new AvailableCatalogLoaders().spliterator(), false).map(arg_0 -> ((PluginCommandType)PluginCommandType.loader).toPluginCommandName(arg_0));
        streamArray[2] = Stream.of("load");
        streamArray[3] = StreamSupport.stream(new AvailableCommands().spliterator(), false).map(arg_0 -> ((PluginCommandType)PluginCommandType.command).toPluginCommandName(arg_0));
        streamArray[4] = Stream.of("execute");
        Stream.of(streamArray).flatMap(i -> i).forEach(command -> this.showHelpForSubcommand(parent, (String)command));
    }

    private void showHelpForSubcommand(CommandLine parent, String command) {
        if (parent == null) {
            return;
        }
        if (Utility.isBlank((CharSequence)command)) {
            return;
        }
        boolean isAvailabilityCommand = Arrays.asList("servers", "loaders", "commands").contains(command);
        Optional<CommandLine> lookupCommand = this.lookupCommand(parent, command);
        if (lookupCommand.isPresent()) {
            CommandLine.Model.CommandSpec commandSpec;
            Object userObject;
            CommandLine subCommand = lookupCommand.get();
            subCommand.usage(System.out, CommandLine.Help.Ansi.AUTO);
            if (isAvailabilityCommand && (userObject = (commandSpec = subCommand.getCommandSpec()).userObject()) != null && userObject instanceof Runnable) {
                ((Runnable)userObject).run();
            }
            System.out.printf("%n%n", new Object[0]);
        }
    }
}

