/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.embeddeddiagram;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.regex.Pattern;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.executable.CommandChain;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.integration.diagram.DiagramOutputFormat;
import schemacrawler.tools.integration.diagram.GraphvizUtility;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.TextOutputFormat;
import us.fatehi.utility.IOUtility;

public class EmbeddedDiagramRenderer
extends BaseSchemaCrawlerCommand {
    private static final Pattern svgInsertionPoint = Pattern.compile("<h2.*Tables.*h2>");
    private static final Pattern svgStart = Pattern.compile("<svg.*");

    private static void insertSvg(BufferedWriter finalHtmlFileWriter, BufferedReader baseSvgFileReader) throws IOException {
        String line;
        finalHtmlFileWriter.append(System.lineSeparator());
        boolean skipLines = true;
        boolean isSvgStart = false;
        while ((line = baseSvgFileReader.readLine()) != null) {
            if (skipLines) {
                isSvgStart = svgStart.matcher(line).matches();
                boolean bl = skipLines = !isSvgStart;
            }
            if (skipLines) continue;
            if (isSvgStart) {
                line = "<svg";
                isSvgStart = false;
            }
            finalHtmlFileWriter.append(line).append(System.lineSeparator());
        }
        finalHtmlFileWriter.append(System.lineSeparator());
    }

    public EmbeddedDiagramRenderer(String command) {
        super(command);
    }

    public void checkAvailability() throws Exception {
        if (GraphvizUtility.isGraphvizAvailable()) {
            return;
        }
        if (GraphvizUtility.isGraphvizJavaAvailable(DiagramOutputFormat.svg)) {
            return;
        }
        throw new SchemaCrawlerException("Cannot generate diagram in SVG format");
    }

    public void execute() throws Exception {
        this.checkCatalog();
        Path finalHtmlFile = IOUtility.createTempFilePath((String)"schemacrawler", (String)"html");
        Path baseHtmlFile = IOUtility.createTempFilePath((String)"schemacrawler", (String)"html");
        Path baseSvgFile = IOUtility.createTempFilePath((String)"schemacrawler", (String)"svg");
        CommandChain chain = new CommandChain((SchemaCrawlerCommand)this);
        chain.addNext(this.command, (OutputFormat)TextOutputFormat.html, baseHtmlFile);
        chain.addNext(this.command, (OutputFormat)DiagramOutputFormat.svg, baseSvgFile);
        chain.execute();
        try (BufferedWriter finalHtmlFileWriter = Files.newBufferedWriter(finalHtmlFile, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
             BufferedReader baseHtmlFileReader = Files.newBufferedReader(baseHtmlFile, StandardCharsets.UTF_8);
             BufferedReader baseSvgFileReader = Files.newBufferedReader(baseSvgFile, StandardCharsets.UTF_8);){
            String line;
            while ((line = baseHtmlFileReader.readLine()) != null) {
                if (svgInsertionPoint.matcher(line).matches()) {
                    EmbeddedDiagramRenderer.insertSvg(finalHtmlFileWriter, baseSvgFileReader);
                }
                finalHtmlFileWriter.append(line).append(System.lineSeparator());
            }
        }
        var6_6 = null;
        try (Writer writer = this.outputOptions.openNewOutputWriter();){
            IOUtility.copy((Reader)Files.newBufferedReader(finalHtmlFile, StandardCharsets.UTF_8), (Writer)writer);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    public boolean usesConnection() {
        return false;
    }
}

