/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.embeddeddiagram;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.regex.Pattern;
import schemacrawler.schemacrawler.exceptions.IORuntimeException;
import schemacrawler.tools.command.text.diagram.DiagramRenderer;
import schemacrawler.tools.command.text.diagram.GraphExecutorFactory;
import schemacrawler.tools.command.text.diagram.options.DiagramOptions;
import schemacrawler.tools.command.text.diagram.options.DiagramOutputFormat;
import schemacrawler.tools.command.text.schema.SchemaTextRenderer;
import schemacrawler.tools.command.text.schema.options.TextOutputFormat;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import us.fatehi.utility.IOUtility;

public class EmbeddedDiagramRenderer
extends BaseSchemaCrawlerCommand<DiagramOptions> {
    private static final Pattern svgInsertionPoint = Pattern.compile("<h2.*Tables.*h2>");
    private static final Pattern svgStart = Pattern.compile("<svg.*");
    private final GraphExecutorFactory graphExecutorFactory;

    private static void insertSvg(BufferedWriter finalHtmlFileWriter, BufferedReader baseSvgFileReader) throws IOException {
        String line;
        finalHtmlFileWriter.append(System.lineSeparator());
        boolean skipLines = true;
        boolean isSvgStart = false;
        while ((line = baseSvgFileReader.readLine()) != null) {
            if (skipLines) {
                isSvgStart = svgStart.matcher(line).matches();
                boolean bl = skipLines = !isSvgStart;
            }
            if (skipLines) continue;
            if (isSvgStart) {
                line = "<svg";
                isSvgStart = false;
            }
            finalHtmlFileWriter.append(line).append(System.lineSeparator());
        }
        finalHtmlFileWriter.append(System.lineSeparator());
    }

    public EmbeddedDiagramRenderer(String command, GraphExecutorFactory graphExecutorFactory) {
        super(command);
        this.graphExecutorFactory = Objects.requireNonNull(graphExecutorFactory, "No graph executor factory provided");
    }

    public void checkAvailability() {
        this.graphExecutorFactory.canGenerate(DiagramOutputFormat.svg);
    }

    public void execute() {
        this.checkCatalog();
        try {
            String stem = "schemacrawler";
            Path finalHtmlFile = IOUtility.createTempFilePath((String)"schemacrawler", (String)DiagramOutputFormat.htmlx.getFormat());
            Path baseHtmlFile = IOUtility.createTempFilePath((String)"schemacrawler", (String)TextOutputFormat.html.getFormat());
            Path baseSvgFile = IOUtility.createTempFilePath((String)"schemacrawler", (String)DiagramOutputFormat.svg.getFormat());
            this.executeCommand((SchemaCrawlerCommand<? super DiagramOptions>)new SchemaTextRenderer(this.command), baseHtmlFile, (OutputFormat)TextOutputFormat.html);
            this.executeCommand((SchemaCrawlerCommand<? super DiagramOptions>)new DiagramRenderer(this.command, this.graphExecutorFactory), baseSvgFile, DiagramOutputFormat.svg);
            try (BufferedWriter finalHtmlFileWriter = Files.newBufferedWriter(finalHtmlFile, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                 BufferedReader baseHtmlFileReader = Files.newBufferedReader(baseHtmlFile, StandardCharsets.UTF_8);
                 BufferedReader baseSvgFileReader = Files.newBufferedReader(baseSvgFile, StandardCharsets.UTF_8);){
                String line;
                while ((line = baseHtmlFileReader.readLine()) != null) {
                    if (svgInsertionPoint.matcher(line).matches()) {
                        EmbeddedDiagramRenderer.insertSvg(finalHtmlFileWriter, baseSvgFileReader);
                    }
                    finalHtmlFileWriter.append(line).append(System.lineSeparator());
                }
            }
            var6_7 = null;
            try (PrintWriter writer = this.outputOptions.openNewOutputWriter();){
                IOUtility.copy((Reader)Files.newBufferedReader(finalHtmlFile, StandardCharsets.UTF_8), (Writer)writer);
            }
            catch (Throwable throwable) {
                var6_7 = throwable;
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IORuntimeException("Could not create embedded diagram", e);
        }
    }

    public boolean usesConnection() {
        return false;
    }

    private void executeCommand(SchemaCrawlerCommand<? super DiagramOptions> scCommand, Path outputFile, OutputFormat outputFormat) {
        OutputOptions outputOptions = OutputOptionsBuilder.builder((OutputOptions)this.getOutputOptions()).withOutputFormat(outputFormat).withOutputFile(outputFile).toOptions();
        scCommand.setCommandOptions(this.commandOptions);
        scCommand.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
        scCommand.setOutputOptions(outputOptions);
        scCommand.setIdentifiers(this.identifiers);
        scCommand.initialize();
        scCommand.checkAvailability();
        scCommand.setCatalog(this.catalog);
        scCommand.execute();
    }
}

