/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.embeddeddb;

import java.io.IOException;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.schemacrawler.ExcludeAll;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.tools.databaseconnector.ConnectionOptions;
import schemacrawler.tools.executable.SchemaCrawlerExecutable;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import sf.util.DatabaseUtility;
import sf.util.IOUtility;
import sf.util.SchemaCrawlerLogger;

public abstract class EmbeddedDatabaseWrapper {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)EmbeddedDatabaseWrapper.class.getName());

    public abstract ConnectionOptions createConnectionOptions() throws SchemaCrawlerException;

    public Connection createDatabaseConnection() throws SchemaCrawlerException {
        try {
            return this.createConnectionOptions().getConnection();
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Cannot load database file", (Throwable)e);
        }
    }

    public Path createDiagram(String extension) throws Exception {
        try (Connection connection = this.createDatabaseConnection();){
            Path path = this.createDiagram(connection, extension);
            return path;
        }
    }

    public abstract String getConnectionUrl();

    public abstract String getDatabase();

    public abstract String getPassword();

    public abstract String getUser();

    public abstract void loadDatabaseFile(Path var1) throws IOException;

    public abstract void startServer() throws SchemaCrawlerException;

    public abstract void stopServer() throws SchemaCrawlerException;

    protected final Path checkDatabaseFile(Path dbFile) throws IOException {
        Path databaseFile = Objects.requireNonNull(dbFile, "No database file path provided").normalize().toAbsolutePath();
        if (!IOUtility.isFileReadable((Path)databaseFile)) {
            IOException e = new IOException("Cannot read database file, " + databaseFile);
            LOGGER.log(Level.FINE, e.getMessage(), (Throwable)e);
            throw e;
        }
        return databaseFile;
    }

    private Path createDiagram(Connection connection, String extension) throws Exception {
        DatabaseUtility.checkConnection((Connection)connection);
        SchemaCrawlerOptionsBuilder schemaCrawlerOptionsBuilder = SchemaCrawlerOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.standard()).includeRoutines((InclusionRule)new ExcludeAll());
        SchemaCrawlerOptions schemaCrawlerOptions = schemaCrawlerOptionsBuilder.toOptions();
        Path diagramFile = IOUtility.createTempFilePath((String)"schemacrawler", (String)extension);
        OutputOptions outputOptions = OutputOptionsBuilder.newOutputOptions((String)extension, (Path)diagramFile);
        SchemaCrawlerExecutable executable = new SchemaCrawlerExecutable("schema");
        executable.setSchemaCrawlerOptions(schemaCrawlerOptions);
        executable.setOutputOptions(outputOptions);
        executable.setConnection(connection);
        executable.execute();
        return diagramFile;
    }
}

