/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.embeddedgraph;

import java.util.ArrayList;
import java.util.Collection;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.ExecutableCommandProvider;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.integration.embeddedgraph.EmbeddedGraphRenderer;
import schemacrawler.tools.integration.graph.GraphOutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import sf.util.Utility;

public final class EmbeddedGraphCommandProvider
extends ExecutableCommandProvider {
    private static Collection<String> supportedCommands = EmbeddedGraphCommandProvider.supportedCommands();

    private static Collection<String> supportedCommands() {
        ArrayList<String> supportedCommands = new ArrayList<String>();
        for (SchemaTextDetailType schemaTextDetailType : SchemaTextDetailType.values()) {
            supportedCommands.add(schemaTextDetailType.name());
        }
        return supportedCommands;
    }

    public EmbeddedGraphCommandProvider() {
        super(supportedCommands, "");
    }

    public String getDescription() {
        return "Display database diagram and schema information in HTML";
    }

    public Collection<String> getSupportedCommands() {
        return EmbeddedGraphCommandProvider.supportedCommands();
    }

    public SchemaCrawlerCommand newSchemaCrawlerCommand(String command) throws SchemaCrawlerException {
        EmbeddedGraphRenderer scCommand = new EmbeddedGraphRenderer(command);
        return scCommand;
    }

    public boolean supportsSchemaCrawlerCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) {
        if (Utility.isBlank((CharSequence)command) || outputOptions == null) {
            return false;
        }
        String format = outputOptions.getOutputFormatValue();
        GraphOutputFormat graphOutputFormat = GraphOutputFormat.fromFormat(format);
        boolean supportsSchemaCrawlerCommand = supportedCommands.contains(command) && graphOutputFormat == GraphOutputFormat.htmlx;
        return supportsSchemaCrawlerCommand;
    }
}

