/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.nio.file.Path;
import java.util.Objects;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.integration.graph.GraphExecutor;
import schemacrawler.tools.integration.graph.GraphOutputFormat;
import sf.util.IOUtility;

abstract class AbstractGraphProcessExecutor
implements GraphExecutor {
    protected final Path dotFile;
    protected final Path outputFile;
    protected final GraphOutputFormat graphOutputFormat;

    protected AbstractGraphProcessExecutor(Path dotFile, Path outputFile, GraphOutputFormat graphOutputFormat) throws SchemaCrawlerException {
        Objects.requireNonNull(dotFile, "No DOT file provided");
        Objects.requireNonNull(outputFile, "No graph output file provided");
        Objects.requireNonNull(graphOutputFormat, "No graph output format provided");
        this.dotFile = dotFile.normalize().toAbsolutePath();
        this.outputFile = outputFile.normalize().toAbsolutePath();
        this.graphOutputFormat = graphOutputFormat;
        if (!IOUtility.isFileReadable((Path)this.dotFile)) {
            throw new SchemaCrawlerException("Cannot read DOT file, " + this.dotFile);
        }
        if (!IOUtility.isFileWritable((Path)this.outputFile)) {
            throw new SchemaCrawlerException("Cannot write output file, " + this.outputFile);
        }
    }
}

