/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.GraphvizEngine;
import guru.nidi.graphviz.engine.GraphvizJdkEngine;
import guru.nidi.graphviz.engine.GraphvizV8Engine;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.integration.graph.GraphOutputFormat;
import sf.util.IOUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

public final class GraphvizJavaExecutorUtility {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)GraphvizJavaExecutorUtility.class.getName());

    public static boolean canMap(GraphOutputFormat graphOutputFormat) {
        return GraphvizJavaExecutorUtility.map(graphOutputFormat) != null;
    }

    public static void generateGraph(Path dotFile, Path outputFile, GraphOutputFormat graphOutputFormat) throws SchemaCrawlerException {
        Objects.requireNonNull(dotFile, "No DOT file provided");
        Objects.requireNonNull(outputFile, "No graph output file provided");
        Objects.requireNonNull(graphOutputFormat, "No graph output format provided");
        try {
            String dotSource = IOUtility.readFully((Reader)new FileReader(dotFile.toFile()));
            dotSource = dotSource.replaceAll("\\R", " ");
            List<GraphvizEngine> engines = GraphvizJavaExecutorUtility.loadGraphvizEngines();
            Graphviz.useEngine(engines);
            Format format = GraphvizJavaExecutorUtility.map(graphOutputFormat);
            Graphviz.fromString((String)dotSource).render(format).toFile(outputFile.toFile());
        }
        catch (Throwable e) {
            throw new SchemaCrawlerException("Cannot generate graph from " + dotFile, e);
        }
    }

    public static boolean isGraphvizJavaAvailable(GraphOutputFormat graphOutputFormat) {
        String className = "guru.nidi.graphviz.engine.Graphviz";
        boolean hasClass = Utility.isClassAvailable((String)"guru.nidi.graphviz.engine.Graphviz");
        boolean supportsFormat = GraphvizJavaExecutorUtility.canMap(graphOutputFormat);
        LOGGER.log(Level.INFO, (Supplier)new StringFormat("Checking if diagram can be generated -  can load <%s> = <%b>,  can generate format <%s> = <%b>", new Object[]{"guru.nidi.graphviz.engine.Graphviz", hasClass, graphOutputFormat.getDescription(), supportsFormat}));
        return hasClass && supportsFormat;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            throw new IllegalArgumentException("<format> <DOT file> <output file>");
        }
        GraphOutputFormat graphOutputFormat = GraphOutputFormat.valueOf(args[0]);
        Path dotFile = Paths.get(args[1], new String[0]).normalize().toAbsolutePath();
        Path outputFile = Paths.get(args[2], new String[0]).normalize().toAbsolutePath();
        GraphvizJavaExecutorUtility.generateGraph(dotFile, outputFile, graphOutputFormat);
    }

    private static List<GraphvizEngine> loadGraphvizEngines() {
        GraphvizV8Engine engine;
        ArrayList<GraphvizEngine> engines = new ArrayList<GraphvizEngine>();
        try {
            engine = new GraphvizV8Engine();
            engines.add((GraphvizEngine)engine);
        }
        catch (NoClassDefFoundError e) {
            LOGGER.log(Level.INFO, "Cannot load GraphvizV8Engine");
        }
        try {
            engine = new GraphvizJdkEngine();
            engines.add((GraphvizEngine)engine);
        }
        catch (NoClassDefFoundError e) {
            LOGGER.log(Level.INFO, "Cannot load GraphvizJdkEngine");
        }
        return engines;
    }

    private static Format map(GraphOutputFormat graphOutputFormat) {
        Format format;
        if (graphOutputFormat == null) {
            return null;
        }
        switch (graphOutputFormat) {
            case svg: {
                format = Format.SVG;
                break;
            }
            case png: {
                format = Format.PNG;
                break;
            }
            case ps: {
                format = Format.PS;
                break;
            }
            case xdot: {
                format = Format.XDOT;
                break;
            }
            case plain: {
                format = Format.PLAIN;
                break;
            }
            default: {
                format = null;
            }
        }
        return format;
    }

    private GraphvizJavaExecutorUtility() {
    }
}

