/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.mustache;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.iosource.InputResource;
import schemacrawler.tools.iosource.InputResourceUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public final class MustacheRenderer
extends BaseSchemaCrawlerCommand {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)MustacheRenderer.class.getName());
    static final String COMMAND = "mustache";

    public MustacheRenderer() {
        super(COMMAND);
    }

    public void checkAvailibility() throws Exception {
    }

    public final void execute() throws Exception {
        this.checkCatalog();
        String templateLocation = this.outputOptions.getOutputFormatValue();
        InputResource inputResource = InputResourceUtility.createInputResource((String)templateLocation);
        LOGGER.log(Level.INFO, (Supplier)new StringFormat("Rendering template <%s> using Mustache", new Object[]{templateLocation}));
        DefaultMustacheFactory mustacheFactory = new DefaultMustacheFactory();
        Mustache mustache = mustacheFactory.compile(inputResource.openNewInputReader(StandardCharsets.UTF_8), templateLocation);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("catalog", this.catalog);
        context.put("identifiers", this.identifiers);
        try (Writer writer = this.outputOptions.openNewOutputWriter();){
            mustache.execute(writer, context).flush();
        }
    }

    public boolean usesConnection() {
        return true;
    }
}

