/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.scripting;

import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.commandline.SchemaCrawlerCommandLineException;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.executable.CommandChain;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.iosource.InputResourceUtility;
import sf.util.IOUtility;
import sf.util.ObjectToString;
import sf.util.SchemaCrawlerLogger;
import sf.util.Utility;

public final class ScriptCommand
extends BaseSchemaCrawlerCommand {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)ScriptCommand.class.getName());
    static final String COMMAND = "script";

    public ScriptCommand() {
        super(COMMAND);
    }

    public void checkAvailibility() throws Exception {
        this.getScriptEngine();
    }

    public final void execute() throws Exception {
        this.checkCatalog();
        Charset inputCharset = this.outputOptions.getInputCharset();
        String outputFormatValue = this.outputOptions.getOutputFormatValue();
        ScriptEngine scriptEngine = this.getScriptEngine();
        try (Reader reader = InputResourceUtility.createInputResource((String)outputFormatValue).openNewInputReader(inputCharset);
             Writer writer = this.outputOptions.openNewOutputWriter();){
            CommandChain chain = new CommandChain((SchemaCrawlerCommand)this);
            scriptEngine.getContext().setWriter(writer);
            scriptEngine.put("catalog", this.catalog);
            scriptEngine.put("connection", this.connection);
            scriptEngine.put("chain", chain);
            if (scriptEngine instanceof Compilable) {
                CompiledScript script = ((Compilable)((Object)scriptEngine)).compile(reader);
                script.eval();
            } else {
                scriptEngine.eval(reader);
            }
        }
    }

    public boolean usesConnection() {
        return true;
    }

    private ScriptEngine getScriptEngine() throws SchemaCrawlerException {
        String scriptFileName = this.outputOptions.getOutputFormatValue();
        if (Utility.isBlank((CharSequence)scriptFileName)) {
            throw new SchemaCrawlerCommandLineException("Please specify a script to execute");
        }
        String scriptExtension = IOUtility.getFileExtension((String)scriptFileName);
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = Utility.isBlank((CharSequence)scriptExtension) ? scriptEngineManager.getEngineByName("nashorn") : scriptEngineManager.getEngineByExtension(scriptExtension);
        if (scriptEngine == null) {
            throw new SchemaCrawlerException("Script engine not found");
        }
        this.logScriptEngineDetails(Level.CONFIG, scriptEngine.getFactory());
        return scriptEngine;
    }

    private void logScriptEngineDetails(Level level, ScriptEngineFactory scriptEngineFactory) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        LOGGER.log(level, String.format("Using script engine%n%s %s (%s %s)%nScript engine names: %s%nSupported file extensions: %s", scriptEngineFactory.getEngineName(), scriptEngineFactory.getEngineVersion(), scriptEngineFactory.getLanguageName(), scriptEngineFactory.getLanguageVersion(), ObjectToString.toString(scriptEngineFactory.getNames()), ObjectToString.toString(scriptEngineFactory.getExtensions())));
    }
}

