/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.scripting;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.integration.scripting.ScriptCommand;
import schemacrawler.tools.iosource.ClasspathInputResource;
import schemacrawler.tools.iosource.EmptyInputResource;
import schemacrawler.tools.iosource.InputResource;
import schemacrawler.tools.options.OutputOptions;
import sf.util.SchemaCrawlerLogger;

public class ScriptCommandProvider
implements CommandProvider {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger((String)ScriptCommandProvider.class.getName());

    public String getDescription() {
        return "Execute a script against a schema";
    }

    public InputResource getHelp() {
        String helpResource = "/help/ScriptExecutable.txt";
        try {
            return new ClasspathInputResource("/help/ScriptExecutable.txt");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, String.format("Could not load help resource <%s>", "/help/ScriptExecutable.txt"), (Throwable)e);
            return new EmptyInputResource();
        }
    }

    public Collection<String> getSupportedCommands() {
        return Arrays.asList("script");
    }

    public SchemaCrawlerCommand newSchemaCrawlerCommand(String command) {
        ScriptCommand scCommand = new ScriptCommand();
        return scCommand;
    }

    public boolean supportsSchemaCrawlerCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) {
        return "script".equals(command);
    }
}

